/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.Profile;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.account.SessionRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TokenUtil;
import org.keycloak.testsuite.util.UserBuilder;

public abstract class AbstractRestServiceTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public TokenUtil tokenUtil = new TokenUtil();
    @Rule
    public AssertEvents events = new AssertEvents(this);
    protected CloseableHttpClient httpClient;
    protected String inUseClientAppUri = OAuthClient.APP_ROOT + "/in-use-client";
    protected String offlineClientAppUri = OAuthClient.APP_ROOT + "/offline-client";
    protected String alwaysDisplayClientAppUri = OAuthClient.APP_ROOT + "/always-display-client";
    protected String apiVersion;

    @Before
    public void before() {
        this.httpClient = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.apiVersion = null;
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.getUsers().add(UserBuilder.create().username("no-account-access").password("password").build());
        testRealm.getUsers().add(UserBuilder.create().username("view-account-access").role("account", "view-profile").password("password").build());
        testRealm.getUsers().add(UserBuilder.create().username("view-applications-access").addRoles("user", "offline_access").role("account", "view-applications").role("account", "manage-consent").password("password").build());
        testRealm.getUsers().add(UserBuilder.create().username("view-consent-access").role("account", "view-consent").password("password").build());
        testRealm.getUsers().add(UserBuilder.create().username("manage-consent-access").role("account", "manage-consent").password("password").build());
        ClientRepresentation inUseApp = ClientBuilder.create().clientId("in-use-client").id(KeycloakModelUtils.generateId()).name("In Use Client").baseUrl(this.inUseClientAppUri).directAccessGrants().secret("secret1").build();
        testRealm.getClients().add(inUseApp);
        ClientRepresentation offlineApp = ClientBuilder.create().clientId("offline-client").id(KeycloakModelUtils.generateId()).name("Offline Client").baseUrl(this.offlineClientAppUri).directAccessGrants().secret("secret1").build();
        testRealm.getClients().add(offlineApp);
        ClientRepresentation offlineApp2 = ClientBuilder.create().clientId("offline-client-without-base-url").id(KeycloakModelUtils.generateId()).name("Offline Client Without Base URL").directAccessGrants().secret("secret1").build();
        testRealm.getClients().add(offlineApp2);
        ClientRepresentation alwaysDisplayApp = ClientBuilder.create().clientId("always-display-client").id(KeycloakModelUtils.generateId()).name("Always Display Client").baseUrl(this.alwaysDisplayClientAppUri).directAccessGrants().alwaysDisplayInConsole(true).secret("secret1").build();
        testRealm.getClients().add(alwaysDisplayApp);
    }

    protected String getAccountUrl(String resource) {
        String url = this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/realms/test/account";
        if (this.apiVersion != null) {
            url = url + "/" + this.apiVersion;
        }
        if (resource != null) {
            url = url + "/" + resource;
        }
        return url;
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT_API, skipRestart=true)
    public void testFeatureDoesntWorkWhenDisabled() {
        this.checkIfFeatureWorks(false);
    }

    private void checkIfFeatureWorks(boolean shouldWorks) {
        block3: {
            try {
                List sessions = (List)SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<List<SessionRepresentation>>(){});
                Assert.assertEquals((long)1L, (long)sessions.size());
                if (!shouldWorks) {
                    Assert.fail((String)"Feature is available, but this moment should be disabled");
                }
            }
            catch (Exception e) {
                if (!shouldWorks) break block3;
                e.printStackTrace();
                Assert.fail((String)"Feature is not available");
            }
        }
    }
}

