/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.text.MessageFormat;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.SAMLPostLogin;
import org.keycloak.testsuite.auth.page.login.SAMLRedirectLogin;
import org.openqa.selenium.Cookie;

public abstract class AbstractAuthTest
extends AbstractKeycloakTest {
    @Page
    protected AuthRealm testRealmPage;
    @Page
    protected OIDCLogin testRealmLoginPage;
    @Page
    protected Account testRealmAccountPage;
    @Page
    protected SAMLPostLogin testRealmSAMLPostLoginPage;
    @Page
    protected SAMLRedirectLogin testRealmSAMLRedirectLoginPage;
    protected UserRepresentation testUser;
    protected UserRepresentation bburkeUser;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setId("test");
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealms.add(testRealmRep);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
    }

    @Before
    public void beforeAuthTest() {
        this.testRealmLoginPage.setAuthRealm(this.testRealmPage);
        this.testRealmAccountPage.setAuthRealm(this.testRealmPage);
        this.testUser = AbstractAuthTest.createUserRepresentation("test", "test@email.test", "test", "user", true);
        Users.setPasswordFor((UserRepresentation)this.testUser, (String)"password");
        this.bburkeUser = AbstractAuthTest.createUserRepresentation("bburke", "bburke@redhat.com", "Bill", "Burke", true);
        Users.setPasswordFor((UserRepresentation)this.bburkeUser, (String)"password");
        this.resetTestRealmSession();
    }

    public void createTestUserWithAdminClient() {
        this.createTestUserWithAdminClient(true);
    }

    public void createTestUserWithAdminClient(boolean setRealmRoles) {
        ApiUtil.removeUserByUsername((RealmResource)this.testRealmResource(), (String)"test");
        this.log.debug((Object)"creating test user");
        String id = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealmResource(), (UserRepresentation)this.testUser, (String)"password");
        this.testUser.setId(id);
        if (setRealmRoles) {
            ApiUtil.assignClientRoles((RealmResource)this.testRealmResource(), (String)id, (String)"realm-management", (String[])new String[]{"view-realm"});
        }
    }

    protected void deleteAllCookiesForTestRealm() {
        this.deleteAllCookiesForRealm(this.testRealmAccountPage.getAuthRealm());
    }

    protected void deleteAllSessionsInTestRealm() {
        this.deleteAllSessionsInRealm(this.testRealmAccountPage.getAuthRealm());
    }

    protected void resetTestRealmSession() {
        this.resetRealmSession(this.testRealmAccountPage.getAuthRealm());
    }

    public void listCookies() {
        this.log.info((Object)"LIST OF COOKIES: ");
        for (Cookie c : this.driver.manage().getCookies()) {
            this.log.info((Object)MessageFormat.format(" {1} {2} {0}", c.getName(), c.getDomain(), c.getPath(), c.getValue()));
        }
    }

    public RealmResource testRealmResource() {
        return this.adminClient.realm(this.testRealmPage.getAuthRealm());
    }

    protected UserResource testUserResource() {
        return this.testRealmResource().users().get(this.testUser.getId());
    }
}

