/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.jboss.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class UpdateProfileBuilder
implements SamlClient.Step {
    private final SamlClientBuilder clientBuilder;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private static final Logger LOG = Logger.getLogger(UpdateProfileBuilder.class);

    public UpdateProfileBuilder(SamlClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        Assert.assertThat((Object)currentResponse, Matchers.statusCodeIsHC(Response.Status.OK));
        String loginPageText = EntityUtils.toString((HttpEntity)currentResponse.getEntity(), (String)"UTF-8");
        Assert.assertThat((Object)loginPageText, (Matcher)org.hamcrest.Matchers.containsString((String)"Update Account Information"));
        return this.handleUpdateProfile(loginPageText, currentURI);
    }

    public SamlClientBuilder build() {
        return this.clientBuilder;
    }

    public UpdateProfileBuilder param(String paramName, String paramValue) {
        if (paramValue != null) {
            this.parameters.put(paramName, paramValue);
        } else {
            this.parameters.remove(paramName);
        }
        return this;
    }

    public UpdateProfileBuilder firstName(String firstName) {
        return this.param("firstName", firstName);
    }

    public UpdateProfileBuilder lastName(String lastName) {
        return this.param("lastName", lastName);
    }

    public UpdateProfileBuilder username(String username) {
        return this.param("username", username);
    }

    public UpdateProfileBuilder email(String email) {
        return this.param("email", email);
    }

    public HttpUriRequest handleUpdateProfile(String loginPage, URI currentURI) {
        Document theUpdateProfilePage = Jsoup.parse((String)loginPage);
        HashSet<String> unusedParams = new HashSet<String>(this.parameters.keySet());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        Iterator iterator = theUpdateProfilePage.getElementsByTag("form").iterator();
        if (iterator.hasNext()) {
            Element form = (Element)iterator.next();
            String method = form.attr("method");
            String action = form.attr("action");
            boolean isPost = method != null && "post".equalsIgnoreCase(method);
            for (Element input : form.getElementsByTag("input")) {
                if (!this.parameters.containsKey(input.attr("name"))) continue;
                parameters.add(new BasicNameValuePair(input.attr("name"), this.parameters.get(input.attr("name"))));
                unusedParams.remove(input.attr("name"));
            }
            if (!unusedParams.isEmpty()) {
                LOG.warnf("Unused parameter names at Update Profile page: %s", unusedParams);
            }
            if (isPost) {
                UrlEncodedFormEntity formEntity;
                HttpPost res = new HttpPost(action);
                try {
                    formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                res.setEntity((HttpEntity)formEntity);
                return res;
            }
            UriBuilder b = UriBuilder.fromPath((String)action);
            for (NameValuePair nameValuePair : parameters) {
                b.queryParam(nameValuePair.getName(), new Object[]{nameValuePair.getValue()});
            }
            return new HttpGet(b.build(new Object[0]));
        }
        throw new IllegalArgumentException("Invalid update profile form: " + loginPage);
    }
}

