/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.junit.Assert;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.runonserver.RunOnServer;

public class SessionStateChecker
implements Runnable {
    private String realmName = "demo";
    private AtomicReference<String> userSessionIdStore;
    private AtomicReference<String> expectedUserSession;
    private String expectedClientSession;
    private SerializableConsumer<UserSessionModel> consumeUserSession;
    private final Map<String, SerializableConsumer<AuthenticatedClientSessionModel>> consumeClientSession = new HashMap<String, SerializableConsumer<AuthenticatedClientSessionModel>>();
    private SerializableFunction<KeycloakSession, String> userSessionIdProvider;
    private SerializableFunction<KeycloakSession, String> clientSessionIdProvider;
    private final KeycloakTestingClient.Server server;

    public SessionStateChecker(KeycloakTestingClient.Server server) {
        this.server = server;
    }

    public SessionStateChecker realmName(String realmName) {
        this.realmName = realmName;
        return this;
    }

    public SessionStateChecker setUserSessionProvider(SerializableFunction<KeycloakSession, String> sessionProvider) {
        this.userSessionIdProvider = sessionProvider;
        return this;
    }

    public SessionStateChecker setClientSessionProvider(SerializableFunction<KeycloakSession, String> sessionProvider) {
        this.clientSessionIdProvider = sessionProvider;
        return this;
    }

    public SessionStateChecker storeUserSessionId(AtomicReference<String> userSessionIdStore) {
        this.userSessionIdStore = userSessionIdStore;
        return this;
    }

    public SessionStateChecker consumeClientSession(String clientSessionId, SerializableConsumer<AuthenticatedClientSessionModel> consumer) {
        this.consumeClientSession.merge(clientSessionId, consumer, (consumer1, consumer2) -> (SerializableConsumer & Serializable)clientSessionModel -> {
            consumer1.accept(clientSessionModel);
            consumer2.accept(clientSessionModel);
        });
        return this;
    }

    public SessionStateChecker consumeUserSession(SerializableConsumer<UserSessionModel> userSessionModelConsumer) {
        this.consumeUserSession = this.consumeUserSession == null ? userSessionModelConsumer : this.mergeConsumers(this.consumeUserSession, userSessionModelConsumer);
        return this;
    }

    public SerializableConsumer<UserSessionModel> mergeConsumers(SerializableConsumer<UserSessionModel> consumer1, SerializableConsumer<UserSessionModel> consumer2) {
        return (SerializableConsumer & Serializable)userSessionModel -> {
            consumer1.accept(userSessionModel);
            consumer2.accept(userSessionModel);
        };
    }

    public SessionStateChecker expectedAction(String clientId, CommonClientSessionModel.Action action) {
        this.consumeClientSession(clientId, (SerializableConsumer<AuthenticatedClientSessionModel>)(SerializableConsumer & Serializable)clientSessionModel -> {
            if (action == null) {
                Assert.assertThat((Object)clientSessionModel, (Matcher)Matchers.notNullValue());
                Assert.assertThat((Object)clientSessionModel.getAction(), (Matcher)Matchers.nullValue());
                return;
            }
            Assert.assertThat((Object)clientSessionModel, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)clientSessionModel.getAction(), (Matcher)Matchers.equalTo((Object)action.name()));
        });
        return this;
    }

    public SessionStateChecker expectedState(UserSessionModel.State state) {
        this.consumeUserSession((SerializableConsumer<UserSessionModel>)(SerializableConsumer & Serializable)userSessionModel -> {
            Assert.assertThat((Object)userSessionModel, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)userSessionModel.getState(), (Matcher)Matchers.equalTo((Object)state));
        });
        return this;
    }

    public SessionStateChecker expectedNumberOfClientSessions(int expectedNumberOfClientSession) {
        this.consumeUserSession((SerializableConsumer<UserSessionModel>)(SerializableConsumer & Serializable)userSession -> Assert.assertThat(userSession.getAuthenticatedClientSessions().keySet(), (Matcher)Matchers.hasSize((int)expectedNumberOfClientSession)));
        return this;
    }

    public SessionStateChecker expectedUserSession(AtomicReference<String> expectedUserSession) {
        this.expectedUserSession = expectedUserSession;
        return this;
    }

    public SessionStateChecker expectedClientSession(String expectedClientSession) {
        this.expectedClientSession = expectedClientSession;
        return this;
    }

    @Override
    public void run() {
        SessionStateChecker.run(this.server, this.realmName, this.userSessionIdStore, this.expectedUserSession, this.expectedClientSession, this.consumeUserSession, this.consumeClientSession, this.userSessionIdProvider, this.clientSessionIdProvider);
    }

    public static void run(KeycloakTestingClient.Server server, String realmName, AtomicReference<String> userSessionIdStore, AtomicReference<String> expectedUserSession, String expectedClientSession, SerializableConsumer<UserSessionModel> consumeUserSession, Map<String, SerializableConsumer<AuthenticatedClientSessionModel>> consumeClientSession, SerializableFunction<KeycloakSession, String> userSessionIdProvider, SerializableFunction<KeycloakSession, String> clientSessionIdProvider) {
        if (server == null || userSessionIdProvider == null) {
            throw new RuntimeException("Wrongly configured session checker");
        }
        if (userSessionIdStore != null) {
            String userSession = server.fetchString(arg_0 -> userSessionIdProvider.apply(arg_0));
            userSessionIdStore.set(userSession.replace("\"", ""));
        }
        server.run((RunOnServer & Serializable)session -> {
            String sessionId = (String)userSessionIdProvider.apply((Object)session);
            if (expectedUserSession != null) {
                Assert.assertThat((Object)sessionId, (Matcher)Matchers.equalTo((Object)((String)expectedUserSession.get())));
            }
            if (expectedClientSession != null) {
                String clientSession = (String)clientSessionIdProvider.apply((Object)session);
                Assert.assertThat((Object)clientSession, (Matcher)Matchers.equalTo((Object)expectedClientSession));
            }
            RealmModel realm = session.realms().getRealmByName(realmName);
            UserSessionModel userSessionModel = session.sessions().getUserSession(realm, sessionId);
            if (consumeUserSession != null) {
                consumeUserSession.accept((Object)userSessionModel);
            }
            if (!consumeClientSession.isEmpty()) {
                consumeClientSession.forEach((id, consumer) -> consumer.accept((Object)userSessionModel.getAuthenticatedClientSessionByClient(id)));
            }
        });
    }
}

