/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.AttributeQueryType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLRequestWriter;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLResponseWriter;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.w3c.dom.Document;

public abstract class SamlDocumentStepBuilder<T extends SAML2Object, This extends SamlDocumentStepBuilder<T, This>>
implements SamlClient.Step {
    private static final Logger LOG = Logger.getLogger(SamlDocumentStepBuilder.class);
    private final SamlClientBuilder clientBuilder;
    private StringTransformer transformer = t -> t;

    public SamlDocumentStepBuilder(SamlClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public This transformObject(Consumer<T> tr) {
        return this.transformObject((T so) -> {
            tr.accept(so);
            return so;
        });
    }

    public This transformObject(Saml2ObjectTransformer<T> tr) {
        StringTransformer original = this.transformer;
        this.transformer = s -> {
            String originalTransformed = original.transform(s);
            if (originalTransformed == null) {
                return null;
            }
            ByteArrayInputStream baos = new ByteArrayInputStream(originalTransformed.getBytes());
            SAML2Object saml2Object = new SAML2Response().getSAML2ObjectFromStream((InputStream)baos);
            SAML2Object transformed = tr.transform(saml2Object);
            if (transformed == null) {
                return null;
            }
            String res = SamlDocumentStepBuilder.saml2Object2String(transformed);
            LOG.debugf("  ---> %s", (Object)res);
            return res;
        };
        return (This)this;
    }

    public static String saml2Object2String(SAML2Object transformed) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter((OutputStream)bos);
            if (transformed instanceof AuthnRequestType) {
                new SAMLRequestWriter(xmlStreamWriter).write((AuthnRequestType)transformed);
            } else if (transformed instanceof LogoutRequestType) {
                new SAMLRequestWriter(xmlStreamWriter).write((LogoutRequestType)transformed);
            } else if (transformed instanceof ArtifactResolveType) {
                new SAMLRequestWriter(xmlStreamWriter).write((ArtifactResolveType)transformed);
            } else if (transformed instanceof AttributeQueryType) {
                new SAMLRequestWriter(xmlStreamWriter).write((AttributeQueryType)transformed);
            } else if (transformed instanceof ResponseType) {
                new SAMLResponseWriter(xmlStreamWriter).write((ResponseType)transformed);
            } else if (transformed instanceof ArtifactResponseType) {
                new SAMLResponseWriter(xmlStreamWriter).write((ArtifactResponseType)transformed);
            } else if (transformed instanceof StatusResponseType) {
                new SAMLResponseWriter(xmlStreamWriter).write((StatusResponseType)transformed, SAMLProtocolQNames.LOGOUT_RESPONSE.getQName("samlp"));
            } else {
                Assert.assertNotNull((String)"Unknown type: <null>", (Object)transformed);
                Assert.fail((String)("Unknown type: " + transformed.getClass().getName()));
            }
            return new String(bos.toByteArray(), GeneralConstants.SAML_CHARSET);
        }
        catch (ProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public This transformDocument(Consumer<Document> tr) {
        return this.transformDocument((Document so) -> {
            tr.accept(so);
            return so;
        });
    }

    public This transformDocument(Saml2DocumentTransformer tr) {
        StringTransformer original = this.transformer;
        this.transformer = s -> {
            String originalTransformed = original.transform(s);
            if (originalTransformed == null) {
                return null;
            }
            Document transformed = tr.transform(DocumentUtil.getDocument((String)originalTransformed));
            return transformed == null ? null : DocumentUtil.getDocumentAsString((Document)transformed);
        };
        return (This)this;
    }

    public This transformString(Consumer<String> tr) {
        return this.transformString((String s) -> {
            tr.accept(s);
            return s;
        });
    }

    public This transformString(StringTransformer tr) {
        StringTransformer original = this.transformer;
        this.transformer = s -> {
            String originalTransformed = original.transform(s);
            if (originalTransformed == null) {
                return null;
            }
            return tr.transform(originalTransformed);
        };
        return (This)this;
    }

    public This apply(Consumer<This> updaterOfThis) {
        updaterOfThis.accept(this);
        return (This)this;
    }

    public SamlClientBuilder build() {
        return this.clientBuilder;
    }

    public StringTransformer getTransformer() {
        return this.transformer;
    }

    @FunctionalInterface
    public static interface StringTransformer {
        public String transform(String var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Saml2DocumentTransformer {
        public Document transform(Document var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Saml2ObjectTransformer<T extends SAML2Object> {
        public T transform(T var1) throws Exception;
    }
}

