/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class RequiredConsentBuilder
implements SamlClient.Step {
    private final SamlClientBuilder clientBuilder;
    private boolean approveConsent = true;

    public RequiredConsentBuilder(SamlClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        Assert.assertThat((Object)currentResponse, Matchers.statusCodeIsHC(Response.Status.OK));
        String consentPageText = EntityUtils.toString((HttpEntity)currentResponse.getEntity(), (String)"UTF-8");
        Assert.assertThat((Object)consentPageText, (Matcher)org.hamcrest.Matchers.containsString((String)"consent"));
        Assert.assertThat((Object)consentPageText, (Matcher)org.hamcrest.Matchers.containsString((String)"My Roles"));
        return this.handleConsentPage(consentPageText, currentURI);
    }

    public SamlClientBuilder build() {
        return this.clientBuilder;
    }

    public RequiredConsentBuilder approveConsent(boolean shouldApproveConsent) {
        this.approveConsent = shouldApproveConsent;
        return this;
    }

    public HttpUriRequest handleConsentPage(String consentPage, URI currentURI) {
        Document theLoginPage = Jsoup.parse((String)consentPage);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        Iterator iterator = theLoginPage.getElementsByTag("form").iterator();
        if (iterator.hasNext()) {
            Element form = (Element)iterator.next();
            String method = form.attr("method");
            String action = form.attr("action");
            boolean isPost = method != null && "post".equalsIgnoreCase(method);
            for (Element input : form.getElementsByTag("input")) {
                if (Objects.equals(input.id(), "kc-login")) {
                    if (!this.approveConsent) continue;
                    parameters.add(new BasicNameValuePair(input.attr("name"), input.attr("value")));
                    continue;
                }
                if (Objects.equals(input.id(), "kc-cancel")) {
                    if (this.approveConsent) continue;
                    parameters.add(new BasicNameValuePair(input.attr("name"), input.attr("value")));
                    continue;
                }
                parameters.add(new BasicNameValuePair(input.attr("name"), input.val()));
            }
            if (isPost) {
                UrlEncodedFormEntity formEntity;
                HttpPost res = new HttpPost(currentURI.resolve(action));
                try {
                    formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                res.setEntity((HttpEntity)formEntity);
                return res;
            }
            UriBuilder b = UriBuilder.fromPath((String)action);
            for (NameValuePair nameValuePair : parameters) {
                b.queryParam(nameValuePair.getName(), new Object[]{nameValuePair.getValue()});
            }
            return new HttpGet(b.build(new Object[0]));
        }
        throw new IllegalArgumentException("Invalid consent page: " + consentPage);
    }
}

