/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.SamlDocumentStepBuilder;

public class ModifySamlResponseStepBuilder
extends SamlDocumentStepBuilder<SAML2Object, ModifySamlResponseStepBuilder> {
    private final SamlClient.Binding binding;
    private URI targetUri;
    private String targetAttribute;
    private SamlClient.Binding targetBinding;
    private Supplier<String> documentSupplier;

    public ModifySamlResponseStepBuilder(SamlClient.Binding binding, SamlClientBuilder clientBuilder) {
        super(clientBuilder);
        this.binding = binding;
        this.targetBinding = binding;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        switch (this.binding) {
            case REDIRECT: {
                return this.handleRedirectBinding(currentResponse);
            }
            case POST: {
                return this.handlePostBinding(currentResponse);
            }
            case ARTIFACT_RESPONSE: {
                return this.handleArtifactResponse(currentResponse);
            }
        }
        throw new RuntimeException("Unknown binding for " + ModifySamlResponseStepBuilder.class.getName());
    }

    public Supplier<String> documentSupplier() {
        return this.documentSupplier;
    }

    public ModifySamlResponseStepBuilder documentSupplier(Supplier<String> documentSupplier) {
        this.documentSupplier = documentSupplier;
        return this;
    }

    public SamlClient.Binding targetBinding() {
        return this.targetBinding;
    }

    public ModifySamlResponseStepBuilder targetBinding(SamlClient.Binding targetBinding) {
        this.targetBinding = targetBinding;
        return this;
    }

    public String targetAttribute() {
        return this.targetAttribute;
    }

    public ModifySamlResponseStepBuilder targetAttribute(String attribute) {
        this.targetAttribute = attribute;
        return this;
    }

    public ModifySamlResponseStepBuilder targetAttributeSamlRequest() {
        return this.targetAttribute("SAMLRequest");
    }

    public ModifySamlResponseStepBuilder targetAttributeSamlResponse() {
        return this.targetAttribute("SAMLResponse");
    }

    public URI targetUri() {
        return this.targetUri;
    }

    public ModifySamlResponseStepBuilder targetUri(URI forceUri) {
        this.targetUri = forceUri;
        return this;
    }

    private HttpUriRequest handleArtifactResponse(CloseableHttpResponse currentResponse) throws Exception {
        SAMLDocumentHolder samlDocumentHolder = null;
        try {
            samlDocumentHolder = SamlClient.Binding.ARTIFACT_RESPONSE.extractResponse(currentResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.createRequest(this.targetUri, this.targetAttribute, DocumentUtil.asString((org.w3c.dom.Document)samlDocumentHolder.getSamlDocument()), new LinkedList<NameValuePair>());
    }

    protected HttpUriRequest handleRedirectBinding(CloseableHttpResponse currentResponse) throws Exception, IOException, URISyntaxException {
        LinkedList<NameValuePair> params;
        String attrName;
        URI uri;
        String samlDoc;
        if (this.documentSupplier != null) {
            Objects.requireNonNull(this.targetUri, "Set targetUri");
            Objects.requireNonNull(this.targetAttribute, "Set targetAttribute");
            samlDoc = this.documentSupplier.get();
            uri = this.targetUri;
            attrName = this.targetAttribute;
            params = new LinkedList<NameValuePair>();
        } else {
            NameValuePair samlParam = null;
            Assert.assertThat((Object)currentResponse, Matchers.statusCodeIsHC(Response.Status.FOUND));
            String location = currentResponse.getFirstHeader("Location").getValue();
            URI locationUri = URI.create(location);
            params = URLEncodedUtils.parse((URI)locationUri, (String)"UTF-8");
            Iterator it = params.iterator();
            while (it.hasNext()) {
                NameValuePair param = (NameValuePair)it.next();
                if (!"SAMLResponse".equals(param.getName()) && !"SAMLRequest".equals(param.getName())) continue;
                Assert.assertThat((String)"Only one SAMLRequest/SAMLResponse check", samlParam, (Matcher)org.hamcrest.Matchers.nullValue());
                samlParam = param;
                it.remove();
            }
            Assert.assertThat(samlParam, (Matcher)org.hamcrest.Matchers.notNullValue());
            String base64EncodedSamlDoc = samlParam.getValue();
            InputStream decoded = RedirectBindingUtil.base64DeflateDecode((String)base64EncodedSamlDoc);
            samlDoc = IOUtils.toString((InputStream)decoded, (Charset)GeneralConstants.SAML_CHARSET);
            IOUtils.closeQuietly((InputStream)decoded);
            uri = this.targetUri != null ? this.targetUri : locationUri;
            attrName = this.targetAttribute != null ? this.targetAttribute : samlParam.getName();
        }
        return this.createRequest(uri, attrName, samlDoc, params);
    }

    private HttpUriRequest handlePostBinding(CloseableHttpResponse currentResponse) throws Exception {
        String attrName;
        URI uri;
        String samlDoc;
        LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
        if (this.documentSupplier != null) {
            Objects.requireNonNull(this.targetUri, "Set targetUri");
            Objects.requireNonNull(this.targetAttribute, "Set targetAttribute");
            samlDoc = this.documentSupplier.get();
            uri = this.targetUri;
            attrName = this.targetAttribute;
        } else {
            Assert.assertThat((Object)currentResponse, Matchers.statusCodeIsHC(Response.Status.OK));
            String htmlBody = EntityUtils.toString((HttpEntity)currentResponse.getEntity());
            Assert.assertThat((Object)htmlBody, (Matcher)org.hamcrest.Matchers.containsString((String)"SAML"));
            Document theResponsePage = Jsoup.parse((String)htmlBody);
            Elements samlResponses = theResponsePage.select("input[name=SAMLResponse]");
            Elements samlRequests = theResponsePage.select("input[name=SAMLRequest]");
            Elements forms = theResponsePage.select("form");
            Elements relayStates = theResponsePage.select("input[name=RelayState]");
            int size = samlResponses.size() + samlRequests.size();
            Assert.assertThat((String)"Checking uniqueness of SAMLResponse/SAMLRequest input field in the page", (Object)size, (Matcher)org.hamcrest.Matchers.is((Object)1));
            Assert.assertThat((String)"Checking uniqueness of forms in the page", (Object)forms, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
            Element respElement = samlResponses.isEmpty() ? samlRequests.first() : samlResponses.first();
            Element form = forms.first();
            String base64EncodedSamlDoc = respElement.val();
            InputStream decoded = PostBindingUtil.base64DecodeAsStream((String)base64EncodedSamlDoc);
            samlDoc = IOUtils.toString((InputStream)decoded, (Charset)GeneralConstants.SAML_CHARSET);
            IOUtils.closeQuietly((InputStream)decoded);
            String string = attrName = this.targetAttribute != null ? this.targetAttribute : respElement.attr("name");
            if (!relayStates.isEmpty()) {
                params.add((NameValuePair)new BasicNameValuePair("RelayState", relayStates.first().val()));
            }
            uri = this.targetUri != null ? this.targetUri : URI.create(form.attr("action"));
        }
        return this.createRequest(uri, attrName, samlDoc, params);
    }

    protected HttpUriRequest createRequest(URI locationUri, String attributeName, String samlDoc, List<NameValuePair> parameters) throws Exception {
        String transformed = this.getTransformer().transform(samlDoc);
        if (transformed == null) {
            return null;
        }
        switch (this.targetBinding) {
            case POST: {
                return this.createPostRequest(locationUri, attributeName, transformed, parameters);
            }
            case REDIRECT: {
                return this.createRedirectRequest(locationUri, attributeName, transformed, parameters);
            }
        }
        throw new RuntimeException("Unknown target binding for " + ModifySamlResponseStepBuilder.class.getName());
    }

    protected HttpUriRequest createRedirectRequest(URI locationUri, String attributeName, String transformed, List<NameValuePair> parameters) throws IOException, URISyntaxException {
        byte[] responseBytes = transformed.getBytes(GeneralConstants.SAML_CHARSET);
        parameters.add((NameValuePair)new BasicNameValuePair(attributeName, RedirectBindingUtil.deflateBase64Encode((byte[])responseBytes)));
        if (this.targetUri != null) {
            locationUri = this.targetUri;
        }
        URI target = new URIBuilder(locationUri).setParameters(parameters).build();
        return new HttpGet(target);
    }

    protected HttpUriRequest createPostRequest(URI locationUri, String attributeName, String transformed, List<NameValuePair> parameters) throws IOException {
        HttpPost post = new HttpPost(locationUri);
        parameters.add((NameValuePair)new BasicNameValuePair(attributeName, PostBindingUtil.base64Encode((String)transformed)));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, GeneralConstants.SAML_CHARSET);
        post.setEntity((HttpEntity)formEntity);
        return post;
    }
}

