/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class LoginBuilder
implements SamlClient.Step {
    private final SamlClientBuilder clientBuilder;
    private UserRepresentation user;
    private boolean sso = false;
    private String idpAlias;

    public LoginBuilder(SamlClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        if (this.sso) {
            return null;
        }
        Assert.assertThat((Object)currentResponse, Matchers.statusCodeIsHC(Response.Status.OK));
        String loginPageText = EntityUtils.toString((HttpEntity)currentResponse.getEntity(), (String)"UTF-8");
        Assert.assertThat((Object)loginPageText, (Matcher)org.hamcrest.Matchers.containsString((String)"login"));
        return this.handleLoginPage(loginPageText, currentURI);
    }

    public SamlClientBuilder build() {
        return this.clientBuilder;
    }

    public LoginBuilder user(UserRepresentation user) {
        this.user = user;
        return this;
    }

    public LoginBuilder user(String userName, String password) {
        this.user = new UserRepresentation();
        this.user.setUsername(userName);
        Users.setPasswordFor(this.user, password);
        return this;
    }

    public LoginBuilder sso(boolean sso) {
        this.sso = sso;
        return this;
    }

    public LoginBuilder idp(String idpAlias) {
        this.idpAlias = idpAlias;
        return this;
    }

    private HttpUriRequest handleLoginPage(String loginPage, URI currentURI) {
        if (this.idpAlias != null) {
            Document theLoginPage = Jsoup.parse((String)loginPage);
            Element socialLink = theLoginPage.getElementById("social-" + this.idpAlias);
            Assert.assertThat((String)("Unknown idp: " + this.idpAlias), (Object)socialLink, (Matcher)org.hamcrest.Matchers.notNullValue());
            String link = socialLink.attr("href");
            Assert.assertThat((String)("Invalid idp link: " + this.idpAlias), (Object)link, (Matcher)org.hamcrest.Matchers.notNullValue());
            return new HttpGet(currentURI.resolve(link));
        }
        return LoginBuilder.handleLoginPage(this.user, loginPage);
    }

    public static HttpUriRequest handleLoginPage(UserRepresentation user, String loginPage) {
        String username = user.getUsername();
        String password = Users.getPasswordOf(user);
        Document theLoginPage = Jsoup.parse((String)loginPage);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        Iterator iterator = theLoginPage.getElementsByTag("form").iterator();
        if (iterator.hasNext()) {
            Element form = (Element)iterator.next();
            String method = form.attr("method");
            String action = form.attr("action");
            boolean isPost = method != null && "post".equalsIgnoreCase(method);
            for (Element input : form.getElementsByTag("input")) {
                if (Objects.equals(input.id(), "username")) {
                    parameters.add(new BasicNameValuePair(input.attr("name"), username));
                    continue;
                }
                if (Objects.equals(input.id(), "password")) {
                    parameters.add(new BasicNameValuePair(input.attr("name"), password));
                    continue;
                }
                parameters.add(new BasicNameValuePair(input.attr("name"), input.val()));
            }
            if (isPost) {
                UrlEncodedFormEntity formEntity;
                HttpPost res = new HttpPost(action);
                try {
                    formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                res.setEntity((HttpEntity)formEntity);
                return res;
            }
            UriBuilder b = UriBuilder.fromPath((String)action);
            for (NameValuePair nameValuePair : parameters) {
                b.queryParam(nameValuePair.getName(), new Object[]{nameValuePair.getValue()});
            }
            return new HttpGet(b.build(new Object[0]));
        }
        throw new IllegalArgumentException("Invalid login form: " + loginPage);
    }
}

