/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.net.URI;
import java.util.function.Supplier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.SamlDocumentStepBuilder;
import org.w3c.dom.Document;

public class CreateLogoutRequestStepBuilder
extends SamlDocumentStepBuilder<LogoutRequestType, CreateLogoutRequestStepBuilder> {
    private final URI authServerSamlUrl;
    private final String issuer;
    private final SamlClient.Binding requestBinding;
    private Supplier<String> sessionIndex = () -> null;
    private Supplier<NameIDType> nameId = () -> null;
    private Supplier<String> relayState = () -> null;
    private String signingPublicKeyPem;
    private String signingPrivateKeyPem;
    private String signingCertificate;

    public CreateLogoutRequestStepBuilder(URI authServerSamlUrl, String issuer, SamlClient.Binding requestBinding, SamlClientBuilder clientBuilder) {
        super(clientBuilder);
        this.authServerSamlUrl = authServerSamlUrl;
        this.issuer = issuer;
        this.requestBinding = requestBinding;
    }

    public String sessionIndex() {
        return this.sessionIndex.get();
    }

    public CreateLogoutRequestStepBuilder sessionIndex(String sessionIndex) {
        this.sessionIndex = () -> sessionIndex;
        return this;
    }

    public CreateLogoutRequestStepBuilder sessionIndex(Supplier<String> sessionIndex) {
        this.sessionIndex = sessionIndex;
        return this;
    }

    public String relayState() {
        return this.relayState.get();
    }

    public CreateLogoutRequestStepBuilder relayState(String relayState) {
        this.relayState = () -> relayState;
        return this;
    }

    public CreateLogoutRequestStepBuilder relayState(Supplier<String> relayState) {
        this.relayState = relayState;
        return this;
    }

    public NameIDType nameId() {
        return this.nameId.get();
    }

    public CreateLogoutRequestStepBuilder nameId(NameIDType nameId) {
        this.nameId = () -> nameId;
        return this;
    }

    public CreateLogoutRequestStepBuilder nameId(Supplier<NameIDType> nameId) {
        this.nameId = nameId;
        return this;
    }

    public CreateLogoutRequestStepBuilder signWith(String signingPrivateKeyPem, String signingPublicKeyPem) {
        return this.signWith(signingPrivateKeyPem, signingPublicKeyPem, null);
    }

    public CreateLogoutRequestStepBuilder signWith(String signingPrivateKeyPem, String signingPublicKeyPem, String signingCertificate) {
        this.signingPrivateKeyPem = signingPrivateKeyPem;
        this.signingPublicKeyPem = signingPublicKeyPem;
        this.signingCertificate = signingCertificate;
        return this;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        SAML2LogoutRequestBuilder builder = new SAML2LogoutRequestBuilder().destination(this.authServerSamlUrl == null ? null : this.authServerSamlUrl.toString()).issuer(this.issuer).sessionIndex(this.sessionIndex()).nameId(this.nameId());
        String documentAsString = DocumentUtil.getDocumentAsString((Document)builder.buildDocument());
        String transformed = this.getTransformer().transform(documentAsString);
        if (transformed == null) {
            return null;
        }
        return this.signingPrivateKeyPem == null ? this.requestBinding.createSamlUnsignedRequest(this.authServerSamlUrl, this.relayState(), DocumentUtil.getDocument((String)transformed)) : this.requestBinding.createSamlSignedRequest(this.authServerSamlUrl, this.relayState(), DocumentUtil.getDocument((String)transformed), this.signingPrivateKeyPem, this.signingPublicKeyPem, this.signingCertificate);
    }
}

