/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.net.URI;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.common.util.Base64;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.SamlDocumentStepBuilder;
import org.w3c.dom.Document;

public class CreateAuthnRequestStepBuilder
extends SamlDocumentStepBuilder<AuthnRequestType, CreateAuthnRequestStepBuilder> {
    private final String issuer;
    private final URI authServerSamlUrl;
    private final SamlClient.Binding requestBinding;
    private final String assertionConsumerURL;
    private String signingPublicKeyPem;
    private String signingPrivateKeyPem;
    private String signingCertificate;
    private URI protocolBinding;
    private String authorizationHeader;
    private final Document forceLoginRequestDocument;
    private Supplier<String> relayState;

    public CreateAuthnRequestStepBuilder(URI authServerSamlUrl, String issuer, String assertionConsumerURL, SamlClient.Binding requestBinding, SamlClientBuilder clientBuilder) {
        super(clientBuilder);
        this.issuer = issuer;
        this.authServerSamlUrl = authServerSamlUrl;
        this.requestBinding = requestBinding;
        this.assertionConsumerURL = assertionConsumerURL;
        this.forceLoginRequestDocument = null;
    }

    public CreateAuthnRequestStepBuilder(URI authServerSamlUrl, Document loginRequestDocument, SamlClient.Binding requestBinding, SamlClientBuilder clientBuilder) {
        super(clientBuilder);
        this.forceLoginRequestDocument = loginRequestDocument;
        this.authServerSamlUrl = authServerSamlUrl;
        this.requestBinding = requestBinding;
        this.issuer = null;
        this.assertionConsumerURL = null;
    }

    public CreateAuthnRequestStepBuilder relayState(Supplier<String> relayState) {
        this.relayState = relayState;
        return this;
    }

    public CreateAuthnRequestStepBuilder relayState(String relayState) {
        this.relayState = () -> relayState;
        return this;
    }

    public CreateAuthnRequestStepBuilder setProtocolBinding(URI protocolBinding) {
        this.protocolBinding = protocolBinding;
        return this;
    }

    public URI getProtocolBinding() {
        return this.protocolBinding;
    }

    public CreateAuthnRequestStepBuilder signWith(String signingPrivateKeyPem, String signingPublicKeyPem) {
        return this.signWith(signingPrivateKeyPem, signingPublicKeyPem, null);
    }

    public CreateAuthnRequestStepBuilder signWith(String signingPrivateKeyPem, String signingPublicKeyPem, String signingCertificate) {
        this.signingPrivateKeyPem = signingPrivateKeyPem;
        this.signingPublicKeyPem = signingPublicKeyPem;
        this.signingCertificate = signingCertificate;
        return this;
    }

    public CreateAuthnRequestStepBuilder basicAuthentication(UserRepresentation user) {
        String username = user.getUsername();
        String password = Users.getPasswordOf(user);
        String pair = username + ":" + password;
        this.authorizationHeader = "Basic " + Base64.encodeBytes((byte[])pair.getBytes());
        return this;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        HttpUriRequest request;
        Document doc = this.createLoginRequestDocument();
        String documentAsString = DocumentUtil.getDocumentAsString((Document)doc);
        String transformed = this.getTransformer().transform(documentAsString);
        if (transformed == null) {
            return null;
        }
        Document samlDoc = DocumentUtil.getDocument((String)transformed);
        String relayState = this.relayState == null ? null : this.relayState.get();
        HttpUriRequest httpUriRequest = request = this.signingPrivateKeyPem == null ? this.requestBinding.createSamlUnsignedRequest(this.authServerSamlUrl, relayState, samlDoc) : this.requestBinding.createSamlSignedRequest(this.authServerSamlUrl, relayState, samlDoc, this.signingPrivateKeyPem, this.signingPublicKeyPem, this.signingCertificate);
        if (this.authorizationHeader != null) {
            request.addHeader("Authorization", this.authorizationHeader);
        }
        return request;
    }

    protected Document createLoginRequestDocument() {
        if (this.forceLoginRequestDocument != null) {
            return this.forceLoginRequestDocument;
        }
        try {
            SAML2Request samlReq = new SAML2Request();
            AuthnRequestType loginReq = samlReq.createAuthnRequestType(UUID.randomUUID().toString(), this.assertionConsumerURL, this.authServerSamlUrl.toString(), this.issuer, this.requestBinding.getBindingUri());
            if (this.protocolBinding != null) {
                loginReq.setProtocolBinding(this.protocolBinding);
            }
            return SAML2Request.convert((RequestAbstractType)loginReq);
        }
        catch (ConfigurationException | ParsingException | ProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

