/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.javascript;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.auth.page.login.OAuthGrant;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.javascript.JSObjectBuilder;
import org.keycloak.testsuite.util.javascript.JavascriptStateValidator;
import org.keycloak.testsuite.util.javascript.JavascriptTestExecutor;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.keycloak.testsuite.util.javascript.XMLHttpRequest;
import org.openqa.selenium.WebDriver;

public class JavascriptTestExecutorWithAuthorization
extends JavascriptTestExecutor {
    public static JavascriptTestExecutorWithAuthorization create(WebDriver driver, OIDCLogin loginPage) {
        return new JavascriptTestExecutorWithAuthorization(driver, loginPage);
    }

    private JavascriptTestExecutorWithAuthorization(WebDriver driver, OIDCLogin loginPage) {
        super(driver, loginPage);
    }

    @Override
    public JavascriptTestExecutorWithAuthorization init(JSObjectBuilder argumentsBuilder, JavascriptStateValidator validator) {
        super.init(argumentsBuilder, validator);
        Object output = this.jsExecutor.executeScript("var callback = arguments[arguments.length - 1];window.authorization = new KeycloakAuthorization(window.keycloak);while (typeof window.authorization === 'undefined') {}return 'Authz initialized'", new Object[0]);
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Object)"Authz initialized"));
        return this;
    }

    @Override
    public JavascriptTestExecutorWithAuthorization login(JavascriptStateValidator validator) {
        super.login(validator);
        return this;
    }

    public JavascriptTestExecutorWithAuthorization loginFormWithScopesWithPossibleConsentPage(UserRepresentation user, JavascriptStateValidator validator, OAuthGrant oAuthGrantPage, String ... scopes) {
        String currentUrl = this.jsDriver.getCurrentUrl();
        if (scopes.length > 0) {
            StringBuilder scopesValue = new StringBuilder();
            for (String scope : scopes) {
                if (scopesValue.length() != 0) {
                    scopesValue.append(" ");
                }
                scopesValue.append(scope);
            }
            scopesValue.append(" openid");
            StringBuilder urlWithScopeParam = new StringBuilder(currentUrl);
            int scopeIndex = currentUrl.indexOf("scope");
            if (scopeIndex != -1) {
                urlWithScopeParam.delete(scopeIndex, currentUrl.indexOf(38, scopeIndex));
                urlWithScopeParam.append("&").append("scope=");
            }
            if (!currentUrl.contains("?")) {
                urlWithScopeParam.append("?scope=");
            }
            urlWithScopeParam.append((CharSequence)scopesValue);
            URLUtils.navigateToUri(urlWithScopeParam.toString());
            WaitUtils.waitForPageToLoad();
        }
        this.loginFormWithPossibleConsentPage(user, oAuthGrantPage, validator);
        return this;
    }

    public JavascriptTestExecutorWithAuthorization loginFormWithPossibleConsentPage(UserRepresentation user, OAuthGrant oAuthGrantPage, JavascriptStateValidator validator) {
        super.loginForm(user);
        try {
            if (oAuthGrantPage.isCurrent(this.jsDriver)) {
                oAuthGrantPage.accept();
                WaitUtils.waitForPageToLoad();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (validator != null) {
            validator.validate(this.jsDriver, null, this.events);
        }
        return this;
    }

    @Override
    public JavascriptTestExecutor sendXMLHttpRequest(XMLHttpRequest request, ResponseValidator validator) {
        String headersString;
        List<String> headersList;
        String wwwAuthenticate;
        Object o = this.jsExecutor.executeScript("if(window.authorization && window.authorization.rpt) return true; else return false;", new Object[0]);
        if (o == null || o.equals(false)) {
            request.includeBearerToken();
        } else {
            request.includeRpt();
        }
        Map<String, Object> result = request.send(this.jsExecutor);
        if ((Long.valueOf(403L).equals(result.get("status")) || Long.valueOf(401L).equals(result.get("status"))) && (wwwAuthenticate = (headersList = Arrays.asList((headersString = (String)result.get("responseHeaders")).split("\r\n"))).stream().filter(s -> s.toLowerCase().startsWith("www-authenticate:")).findFirst().get()).contains("UMA") && wwwAuthenticate.contains("ticket")) {
            String ticket = Arrays.asList(wwwAuthenticate.split(",")).stream().filter(s -> s.startsWith("ticket")).findFirst().get();
            ticket = ticket.substring(0, ticket.length() - 1).replaceFirst("ticket=\"", "");
            o = this.jsExecutor.executeAsyncScript("var callback = arguments[arguments.length - 1];window.authorization.authorize(" + JSObjectBuilder.create().add("ticket", ticket).build() + ").then(function (rpt) {callback(rpt)}, function() {callback('failed1')}, function() {callback('failed2')});", new Object[0]);
            o = this.jsExecutor.executeScript("if(window.authorization && window.authorization.rpt) return true; else return false;", new Object[0]);
            if (o != null && o.equals(true)) {
                request.includeRpt();
                result = request.send(this.jsExecutor);
            }
        }
        if (validator != null) {
            validator.validate(result);
        }
        return this;
    }
}

