/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;

public class VaultUtils {
    public static void enableVault(SuiteContext suiteContext, EnableVault.PROVIDER_ID provider) throws IOException, CliException, TimeoutException, InterruptedException {
        ContainerInfo serverInfo = suiteContext.getAuthServerInfo();
        if (serverInfo.isUndertow()) {
            System.setProperty("keycloak.vault." + provider.getName() + ".provider.enabled", "true");
        } else if (serverInfo.isJBossBased()) {
            OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();
            client.execute("/subsystem=keycloak-server/spi=vault/:add(default-provider=" + provider.getName() + ")");
            for (String command : provider.getCliInstallationCommands()) {
                client.execute(command);
            }
            client.close();
        }
    }

    public static void disableVault(SuiteContext suiteContext, EnableVault.PROVIDER_ID provider) throws IOException, CliException, TimeoutException, InterruptedException {
        ContainerInfo serverInfo = suiteContext.getAuthServerInfo();
        if (serverInfo.isUndertow()) {
            System.setProperty("keycloak.vault." + provider.getName() + ".provider.enabled", "false");
        } else if (serverInfo.isJBossBased()) {
            OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();
            for (String command : provider.getCliRemovalCommands()) {
                client.execute(command);
            }
            client.execute("/subsystem=keycloak-server/spi=vault/:remove");
            client.close();
        }
    }
}

