/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.UserInfo;
import org.keycloak.testsuite.util.OAuthClient;

public class UserInfoClientUtil {
    public static Response executeUserInfoRequest_getMethod(Client client, String accessToken) {
        WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget(client);
        return userInfoTarget.request().header("Authorization", (Object)("bearer " + accessToken)).get();
    }

    public static WebTarget getUserInfoWebTarget(Client client) {
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        UriBuilder uriBuilder = OIDCLoginProtocolService.userInfoUrl((UriBuilder)builder);
        URI userInfoUri = uriBuilder.build(new Object[]{"test"});
        return client.target(userInfoUri);
    }

    public static UserInfo testSuccessfulUserInfoResponse(Response response, String expectedUsername, String expectedEmail) {
        return UserInfoClientUtil.testSuccessfulUserInfoResponse(response, null, expectedUsername, expectedEmail);
    }

    public static UserInfo testSuccessfulUserInfoResponse(Response response, String userId, String expectedUsername, String expectedEmail) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)response.getHeaderString("Content-Type"), (Object)"application/json");
        UserInfo userInfo = (UserInfo)response.readEntity(UserInfo.class);
        response.close();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertNotNull((Object)userInfo.getSubject());
        if (userId != null) {
            Assert.assertEquals((Object)userId, (Object)userInfo.getSubject());
        }
        Assert.assertEquals((Object)expectedEmail, (Object)userInfo.getEmail());
        Assert.assertEquals((Object)expectedUsername, (Object)userInfo.getPreferredUsername());
        return userInfo;
    }
}

