/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class URLUtils {
    private static Logger log = Logger.getLogger(URLUtils.class);

    public static void navigateToUri(String uri) {
        URLUtils.navigateToUri(uri, true);
    }

    private static void navigateToUri(String uri, boolean enableIEWorkaround) {
        WebDriver driver = DroneUtils.getCurrentDriver();
        log.info((Object)"starting navigation");
        if (driver instanceof InternetExplorerDriver && driver.getCurrentUrl().equals(uri)) {
            log.info((Object)"IE workaround: target URL equals current URL - refreshing the page");
            driver.navigate().refresh();
            WaitUtils.waitForPageToLoad();
        }
        log.info((Object)("current URL:  " + driver.getCurrentUrl()));
        log.info((Object)("navigating to " + uri));
        if (driver.getCurrentUrl().equals(uri)) {
            log.info((Object)"target URL equals current URL - refreshing the page");
            driver.navigate().refresh();
        } else {
            driver.navigate().to(uri);
        }
        WaitUtils.waitForPageToLoad();
        log.info((Object)("new current URL:  " + driver.getCurrentUrl()));
        if (enableIEWorkaround && driver instanceof InternetExplorerDriver && (driver.getCurrentUrl().matches("^[^#]+/#state=[^#/&]+&code=[^#/&]+$") || driver.getCurrentUrl().matches("^.+/auth/admin/[^/]+/console/$"))) {
            log.info((Object)"IE workaround: reloading the page after deleting the cookies...");
            URLUtils.navigateToUri(uri, false);
        } else {
            log.info((Object)"navigation complete");
        }
    }

    public static boolean currentUrlEquals(String url) {
        return URLUtils.urlCheck(ExpectedConditions.urlToBe((String)ServerURLs.removeDefaultPorts((String)url)));
    }

    public static boolean currentUrlDoesntEqual(String url) {
        return URLUtils.urlCheck(ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlToBe((String)url)));
    }

    public static boolean currentUrlWithQueryEquals(String expectedUrl, String ... expectedQuery) {
        List<String> expectedQueryList = Arrays.asList(expectedQuery);
        ExpectedCondition condition = driver -> {
            String[] urlParts = driver.getCurrentUrl().split("\\?", 2);
            if (urlParts.length != 2) {
                throw new RuntimeException("Current URL doesn't contain query string");
            }
            List<String> queryParts = Arrays.asList(urlParts[1].split("&"));
            return urlParts[0].equals(expectedUrl) && queryParts.containsAll(expectedQueryList);
        };
        return URLUtils.urlCheck(condition);
    }

    public static boolean currentUrlStartsWith(String url) {
        return URLUtils.currentUrlMatches("^" + Pattern.quote(ServerURLs.removeDefaultPorts((String)url)) + ".*$");
    }

    public static boolean currentUrlDoesntStartWith(String url) {
        return URLUtils.currentUrlMatches("^(?!" + Pattern.quote(ServerURLs.removeDefaultPorts((String)url)) + ").+$");
    }

    public static boolean currentUrlMatches(String regex) {
        return URLUtils.urlCheck(ExpectedConditions.urlMatches((String)regex));
    }

    private static boolean urlCheck(ExpectedCondition condition) {
        return URLUtils.urlCheck(condition, false);
    }

    private static boolean urlCheck(ExpectedCondition condition, boolean secondTry) {
        WebDriver driver = DroneUtils.getCurrentDriver();
        try {
            new WebDriverWait(driver, 5L, 100L).until((Function)condition);
        }
        catch (TimeoutException e) {
            if (driver instanceof InternetExplorerDriver && !secondTry) {
                log.info((Object)"IE workaround: checking URL failed at first attempt - refreshing the page and trying one more time...");
                driver.navigate().refresh();
                URLUtils.urlCheck(condition, true);
            }
            return false;
        }
        return true;
    }

    public static void sendPOSTRequestWithWebDriver(String postRequestUrl, String encodedFormParameters) {
        WebDriver driver = DroneUtils.getCurrentDriver();
        URI uri = KeycloakUriBuilder.fromUri((String)(OAuthClient.AUTH_SERVER_ROOT + "/realms/master/testing/simulate-post-request")).queryParam("postRequestUrl", new Object[]{postRequestUrl}).queryParam("encodedFormParameters", new Object[]{encodedFormParameters}).build(new Object[0]);
        driver.navigate().to(uri.toString());
    }
}

