/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import io.appium.java_client.android.AndroidDriver;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.testsuite.page.AbstractPatternFlyAlert;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class UIUtils {
    public static final String VALUE_ATTR_NAME = "value";
    public static final String ARIA_INVALID_ATTR_NAME = "aria-invalid";

    public static boolean selectContainsOption(Select select, String optionText) {
        for (WebElement option : select.getOptions()) {
            if (!option.getText().trim().equals(optionText)) continue;
            return true;
        }
        return false;
    }

    public static boolean currentTitleEquals(String url) {
        try {
            new WebDriverWait(DroneUtils.getCurrentDriver(), 5L).until((Function)ExpectedConditions.titleIs((String)url));
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    public static void performOperationWithPageReload(Runnable operation) {
        operation.run();
        WaitUtils.waitForPageToLoad();
    }

    public static void refreshPageAndWaitForLoad() {
        UIUtils.performOperationWithPageReload(() -> DroneUtils.getCurrentDriver().navigate().refresh());
    }

    public static void clickLink(WebElement element) {
        WebDriver driver = DroneUtils.getCurrentDriver();
        WaitUtils.waitUntilElement(element).is().clickable();
        if (driver instanceof SafariDriver && !element.isDisplayed()) {
            UIUtils.performOperationWithPageReload(() -> new Actions(driver).click(element).perform());
        } else {
            UIUtils.performOperationWithPageReload(() -> ((WebElement)element).click());
        }
    }

    public static void clickBtnAndWaitForAlert(WebElement button) {
        button.click();
        AbstractPatternFlyAlert.waitUntilDisplayed();
    }

    public static void navigateToLink(WebElement element) {
        URLUtils.navigateToUri(element.getAttribute("href"));
    }

    public static void sendKeysToInvisibleElement(WebElement element, CharSequence ... keys) {
        if (element.isDisplayed()) {
            element.sendKeys(keys);
            return;
        }
        JavascriptExecutor jsExecutor = (JavascriptExecutor)DroneUtils.getCurrentDriver();
        String styleBckp = element.getAttribute("style");
        jsExecutor.executeScript("arguments[0].setAttribute('style', 'display:block !important');", new Object[]{element});
        WaitUtils.waitUntilElement(element).is().visible();
        element.sendKeys(keys);
        jsExecutor.executeScript("arguments[0].setAttribute('style', '" + styleBckp + "');", new Object[]{element});
    }

    public static String getTextInputValue(WebElement input) {
        return input.getAttribute(VALUE_ATTR_NAME);
    }

    public static void setTextInputValue(WebElement input, String value) {
        input.click();
        input.clear();
        if (!StringUtils.isEmpty((CharSequence)value)) {
            input.sendKeys(new CharSequence[]{value});
        } else {
            input.sendKeys(new CharSequence[]{"1"});
            input.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
        WebDriver driver = DroneUtils.getCurrentDriver();
        if (driver instanceof AndroidDriver) {
            AndroidDriver androidDriver = (AndroidDriver)driver;
            androidDriver.hideKeyboard();
        }
    }

    public static String getTextFromElement(WebElement element) {
        String text = element.getText();
        if (DroneUtils.getCurrentDriver() instanceof SafariDriver) {
            try {
                text = element.findElement(By.xpath((String)"./span[not(contains(@class,'ng-hide'))]")).getText();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return text.trim();
        }
        return text;
    }

    public static boolean isElementVisible(WebElement element) {
        try {
            return element.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static void scrollElementIntoView(WebElement element) {
        ((JavascriptExecutor)DroneUtils.getCurrentDriver()).executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
    }

    public static boolean doesElementClassContain(WebElement element, String value) {
        try {
            WaitUtils.waitUntilElementClassContains(element, value);
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    public static boolean isElementDisabled(WebElement element) {
        return element.getAttribute("disabled") != null;
    }

    public static boolean isInputElementValid(WebElement element) {
        String ariaInvalid = element.getAttribute(ARIA_INVALID_ATTR_NAME);
        return !Boolean.parseBoolean(ariaInvalid);
    }

    public static String getRawPageSource(WebDriver driver) {
        if (driver instanceof FirefoxDriver) {
            return driver.findElement(By.tagName((String)"body")).getText();
        }
        return driver.getPageSource();
    }

    public static String getRawPageSource() {
        return UIUtils.getRawPageSource(DroneUtils.getCurrentDriver());
    }
}

