/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.TestContext;

public class TokenSignatureUtil {
    private static Logger log = Logger.getLogger(TokenSignatureUtil.class);
    private static final String TEST_REALM_NAME = "test";

    public static void changeRealmTokenSignatureProvider(Keycloak adminClient, String toSigAlgName) {
        TokenSignatureUtil.changeRealmTokenSignatureProvider(TEST_REALM_NAME, adminClient, toSigAlgName);
    }

    public static void changeRealmTokenSignatureProvider(String realm, Keycloak adminClient, String toSigAlgName) {
        RealmRepresentation rep = adminClient.realm(realm).toRepresentation();
        log.tracef("change realm test signature algorithm from %s to %s", (Object)rep.getDefaultSignatureAlgorithm(), (Object)toSigAlgName);
        rep.setDefaultSignatureAlgorithm(toSigAlgName);
        adminClient.realm(realm).update(rep);
    }

    public static void changeClientAccessTokenSignatureProvider(ClientResource clientResource, String toSigAlgName) {
        ClientRepresentation clientRep = clientResource.toRepresentation();
        log.tracef("change client %s access token signature algorithm from %s to %s", (Object)clientRep.getClientId(), clientRep.getAttributes().get("access.token.signed.response.alg"), (Object)toSigAlgName);
        clientRep.getAttributes().put("access.token.signed.response.alg", toSigAlgName);
        clientResource.update(clientRep);
    }

    public static void changeClientIdTokenSignatureProvider(ClientResource clientResource, String toSigAlgName) {
        ClientRepresentation clientRep = clientResource.toRepresentation();
        log.tracef("change client %s access token signature algorithm from %s to %s", (Object)clientRep.getClientId(), clientRep.getAttributes().get("id.token.signed.response.alg"), (Object)toSigAlgName);
        clientRep.getAttributes().put("id.token.signed.response.alg", toSigAlgName);
        clientResource.update(clientRep);
    }

    public static void changeClientIdTokenEncryptionAlgProvider(ClientResource clientResource, String toAlgName) {
        ClientRepresentation clientRep = clientResource.toRepresentation();
        log.tracef("change client %s id token encryption alg algorithm from %s to %s", (Object)clientRep.getClientId(), clientRep.getAttributes().get("id.token.encrypted.response.alg"), (Object)toAlgName);
        clientRep.getAttributes().put("id.token.encrypted.response.alg", toAlgName);
        clientResource.update(clientRep);
    }

    public static void changeClientIdTokenEncryptionEncProvider(ClientResource clientResource, String toEncName) {
        ClientRepresentation clientRep = clientResource.toRepresentation();
        log.tracef("change client %s id token encryption enc algorithm from %s to %s", (Object)clientRep.getClientId(), clientRep.getAttributes().get("id.token.encrypted.response.enc"), (Object)toEncName);
        clientRep.getAttributes().put("id.token.encrypted.response.enc", toEncName);
        clientResource.update(clientRep);
    }

    public static boolean verifySignature(String sigAlgName, String token, Keycloak adminClient) throws Exception {
        PublicKey publicKey = TokenSignatureUtil.getRealmPublicKey(TEST_REALM_NAME, sigAlgName, adminClient);
        JWSInput jws = new JWSInput(token);
        Signature verifier = TokenSignatureUtil.getSignature(sigAlgName);
        verifier.initVerify(publicKey);
        verifier.update(jws.getEncodedSignatureInput().getBytes("UTF-8"));
        return verifier.verify(jws.getSignature());
    }

    public static void registerKeyProvider(String jwaAlgorithmName, Keycloak adminClient, TestContext testContext) {
        TokenSignatureUtil.registerKeyProvider(TEST_REALM_NAME, jwaAlgorithmName, adminClient, testContext);
    }

    public static void registerKeyProvider(String realm, String jwaAlgorithmName, Keycloak adminClient, TestContext testContext) {
        switch (jwaAlgorithmName) {
            case "RS256": 
            case "RS384": 
            case "RS512": 
            case "PS256": 
            case "PS384": 
            case "PS512": {
                TokenSignatureUtil.registerKeyProvider(realm, "algorithm", jwaAlgorithmName, "rsa-generated", adminClient, testContext);
                break;
            }
            case "ES256": 
            case "ES384": 
            case "ES512": {
                TokenSignatureUtil.registerKeyProvider(realm, "ecdsaEllipticCurveKey", TokenSignatureUtil.convertAlgorithmToECDomainParamNistRep(jwaAlgorithmName), "ecdsa-generated", adminClient, testContext);
            }
        }
    }

    public static String convertAlgorithmToECDomainParamNistRep(String algorithm) {
        switch (algorithm) {
            case "ES256": {
                return "P-256";
            }
            case "ES384": {
                return "P-384";
            }
            case "ES512": {
                return "P-521";
            }
        }
        return null;
    }

    private static void registerKeyProvider(String realm, String providerSpecificKey, String providerSpecificValue, String providerId, Keycloak adminClient, TestContext testContext) {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = TokenSignatureUtil.createKeyRep("valid", providerId);
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        rep.getConfig().putSingle((Object)providerSpecificKey, (Object)providerSpecificValue);
        try (Response response = adminClient.realm(realm).components().add(rep);){
            String id = ApiUtil.getCreatedId(response);
            testContext.getOrCreateCleanup(realm).addComponentId(id);
        }
    }

    private static ComponentRepresentation createKeyRep(String name, String providerId) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId(TEST_REALM_NAME);
        rep.setProviderId(providerId);
        rep.setProviderType(KeyProvider.class.getName());
        rep.setConfig(new MultivaluedHashMap());
        return rep;
    }

    private static PublicKey getRealmPublicKey(String realm, String sigAlgName, Keycloak adminClient) {
        KeysMetadataRepresentation keyMetadata = adminClient.realms().realm(realm).keys().getKeyMetadata();
        String activeKid = (String)keyMetadata.getActive().get(sigAlgName);
        PublicKey publicKey = null;
        for (KeysMetadataRepresentation.KeyMetadataRepresentation rep : keyMetadata.getKeys()) {
            if (!rep.getKid().equals(activeKid)) continue;
            X509EncodedKeySpec publicKeySpec = null;
            try {
                publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)rep.getPublicKey()));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            KeyFactory kf = null;
            try {
                kf = KeyFactory.getInstance(rep.getType());
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            try {
                publicKey = kf.generatePublic(publicKeySpec);
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
        }
        return publicKey;
    }

    private static Signature getSignature(String sigAlgName) {
        try {
            Signature signature = Signature.getInstance(JavaAlgorithm.getJavaAlgorithm((String)sigAlgName), "BC");
            return signature;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

