/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class TextFileChecker {
    private static final Logger log = Logger.getLogger(TextFileChecker.class);
    private final Map<Path, Long> lastCheckedPositions = new HashMap<Path, Long>();
    private final Path[] paths;

    public TextFileChecker(Path ... paths) {
        this.paths = paths;
    }

    private void updateLastCheckedPositionsOfAllFilesToEndOfFile(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            this.lastCheckedPositions.put(path, Files.size(path));
        } else {
            this.lastCheckedPositions.remove(path);
        }
    }

    public void checkFiles(boolean verbose, Consumer<Stream<String>> lineChecker) throws IOException {
        for (Path path : this.paths) {
            log.logf(verbose ? Logger.Level.INFO : Logger.Level.DEBUG, "Checking server log: '%s'", (Object)path.toAbsolutePath());
            if (!Files.exists(path, new LinkOption[0])) continue;
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                Long lastCheckedPosition = this.lastCheckedPositions.computeIfAbsent(path, p -> 0L);
                in.skip(lastCheckedPosition);
                try (BufferedReader b = new BufferedReader(new InputStreamReader(in));){
                    lineChecker.accept(b.lines());
                }
            }
        }
    }

    public void updateLastCheckedPositionsOfAllFilesToEndOfFile() throws IOException {
        for (Path path : this.paths) {
            this.updateLastCheckedPositionsOfAllFilesToEndOfFile(path);
        }
    }
}

