/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.SQLExec;
import org.jboss.logging.Logger;

public class SqlUtils {
    protected static final Logger log = Logger.getLogger(SqlUtils.class);

    public static void runSqlScript(String sqlFilePath, String jdbcDriverClass, String dbUrl, String dbUsername, String dbPassword) {
        log.infof("Running SQL script from file '%s'\n jdbcDriverClass=%s\n dbUrl=%s\n dbUsername=%s\n dbPassword=%s\n", new Object[]{sqlFilePath, jdbcDriverClass, dbUrl, dbUsername, dbPassword});
        final class SqlExecuter
        extends SQLExec {
            public SqlExecuter() {
                Project project = new Project();
                project.init();
                this.setProject(project);
                this.setTaskType("sql");
                this.setTaskName("sql");
            }
        }
        SqlExecuter executer = new SqlExecuter();
        executer.setSrc(new File(sqlFilePath));
        executer.setDriver(jdbcDriverClass);
        executer.setPassword(dbPassword);
        executer.setUserid(dbUsername);
        executer.setUrl(dbUrl);
        if (dbUrl.contains("mssql") || jdbcDriverClass.contains("mssql") || jdbcDriverClass.contains("sqlserver")) {
            log.info((Object)"Using alternative delimiter due the MSSQL");
            executer.setDelimiter("GO");
            SQLExec.DelimiterType dt = new SQLExec.DelimiterType();
            dt.setValue("row");
            executer.setDelimiterType(dt);
        }
        if (dbUrl.contains("oracle") || jdbcDriverClass.contains("oracle")) {
            log.info((Object)"Removing 'SET DEFINE OFF' from the SQL script due the Oracle");
            try {
                String content = IOUtils.toString((InputStream)new FileInputStream(sqlFilePath), (Charset)StandardCharsets.UTF_8);
                content = content.replaceAll("SET DEFINE OFF;", "");
                IOUtils.write((String)content, (OutputStream)new FileOutputStream(sqlFilePath), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException fnfe) {
                throw new RuntimeException(fnfe);
            }
        }
        try {
            executer.execute();
        }
        catch (Exception e) {
            try {
                String sqlScript = IOUtils.toString((InputStream)new FileInputStream(sqlFilePath), (Charset)StandardCharsets.UTF_8);
                log.errorf("Exception during manual migration. Content of the SQL file: \n%s\n", (Object)sqlScript);
            }
            catch (Exception e2) {
                log.error((Object)"Exception when trying to log content of SQL file", (Throwable)e2);
            }
            throw e;
        }
    }

    public static void main(String[] args) {
        String sqlFilePath = SqlUtils.readProperty("sqlFilePath");
        String jdbcDriverClass = SqlUtils.readProperty("keycloak.connectionsJpa.driver");
        String dbUrl = SqlUtils.readProperty("keycloak.connectionsJpa.url");
        String dbUsername = SqlUtils.readProperty("keycloak.connectionsJpa.user");
        String dbPassword = SqlUtils.readProperty("keycloak.connectionsJpa.password");
        SqlUtils.runSqlScript(sqlFilePath, jdbcDriverClass, dbUrl, dbUsername, dbPassword);
    }

    private static String readProperty(String propertyName) {
        String val = System.getProperty(propertyName);
        if (val == null) {
            throw new RuntimeException("Undefined system property: " + propertyName);
        }
        return val;
    }
}

