/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.Objects;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.ConditionAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;

public class SamlStreams {
    public static Stream<AssertionType> assertionsUnencrypted(SAML2Object ob) {
        Assert.assertThat((Object)ob, (Matcher)Matchers.instanceOf(ResponseType.class));
        return ((ResponseType)ob).getAssertions().stream().map(ResponseType.RTChoiceType::getAssertion).filter(Objects::nonNull);
    }

    public static Stream<AttributeStatementType> attributeStatements(Stream<AssertionType> ob) {
        return ob.flatMap(assertionType -> assertionType.getAttributeStatements().stream());
    }

    public static Stream<AttributeType> attributesUnecrypted(Stream<AttributeStatementType> ob) {
        return ob.flatMap(ast -> ast.getAttributes().stream()).map(AttributeStatementType.ASTChoiceType::getAttribute).filter(Objects::nonNull);
    }

    public static Stream<ConditionAbstractType> conditions(Stream<AssertionType> ob) {
        return ob.map(AssertionType::getConditions).flatMap(ct -> ct.getConditions().stream());
    }
}

