/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.jboss.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.util.JAXPValidationUtil;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.keycloak.testsuite.util.KeyUtils;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlUtils;
import org.keycloak.testsuite.util.saml.StepWithCheckers;
import org.w3c.dom.Node;

public class SamlClient {
    private static final Logger LOG = Logger.getLogger(SamlClient.class);
    private final HttpClientContext context = HttpClientContext.create();
    private final RedirectStrategyWithSwitchableFollowRedirect strategy = new RedirectStrategyWithSwitchableFollowRedirect();

    public static SAMLDocumentHolder extractSamlResponseFromForm(String responsePage) {
        Document theResponsePage = Jsoup.parse((String)responsePage);
        Elements samlResponses = theResponsePage.select("input[name=SAMLResponse]");
        Elements samlRequests = theResponsePage.select("input[name=SAMLRequest]");
        int size = samlResponses.size() + samlRequests.size();
        Assert.assertThat((String)"Checking uniqueness of SAMLResponse/SAMLRequest input field in the page", (Object)size, (Matcher)org.hamcrest.Matchers.is((Object)1));
        Element respElement = samlResponses.isEmpty() ? samlRequests.first() : samlResponses.first();
        return SAMLRequestParser.parseResponsePostBinding((String)respElement.val());
    }

    public static String extractSamlRelayStateFromForm(String responsePage) {
        Assert.assertThat((Object)responsePage, (Matcher)org.hamcrest.Matchers.containsString((String)"form name=\"saml-post-binding\""));
        Document theResponsePage = Jsoup.parse((String)responsePage);
        Elements samlRelayStates = theResponsePage.select("input[name=RelayState]");
        if (samlRelayStates.isEmpty()) {
            return null;
        }
        return samlRelayStates.first().val();
    }

    public static String extractRelayStateFromRedirect(String responseUri) {
        List params = URLEncodedUtils.parse((URI)URI.create(responseUri), (String)"UTF-8");
        return params.stream().filter(nameValuePair -> nameValuePair.getName().equals("RelayState")).findFirst().map(NameValuePair::getValue).orElse(null);
    }

    public static MultivaluedMap<String, String> parseEncodedQueryParameters(String queryString) throws IOException {
        MultivaluedHashMap encodedParams = new MultivaluedHashMap();
        if (queryString != null) {
            String[] params;
            for (String param : params = queryString.split("&")) {
                if (param.indexOf(61) >= 0) {
                    String[] nv = param.split("=", 2);
                    encodedParams.add((Object)RedirectBindingUtil.urlDecode((String)nv[0]), (Object)(nv.length > 1 ? nv[1] : ""));
                    continue;
                }
                encodedParams.add((Object)RedirectBindingUtil.urlDecode((String)param), (Object)"");
            }
        }
        return encodedParams;
    }

    public static SAMLDocumentHolder extractSamlResponseFromRedirect(String responseUri, final String realmPublicKey) throws IOException {
        MultivaluedMap<String, String> encodedParams = SamlClient.parseEncodedQueryParameters(URI.create(responseUri).getRawQuery());
        String samlResponse = (String)encodedParams.getFirst((Object)"SAMLResponse");
        String samlRequest = (String)encodedParams.getFirst((Object)"SAMLRequest");
        Assert.assertTrue((String)"Only one SAMLRequest/SAMLResponse check", (samlResponse != null && samlRequest == null || samlResponse == null && samlRequest != null ? 1 : 0) != 0);
        String samlDoc = RedirectBindingUtil.urlDecode((String)(samlResponse != null ? samlResponse : samlRequest));
        SAMLDocumentHolder documentHolder = SAMLRequestParser.parseResponseRedirectBinding((String)samlDoc);
        if (realmPublicKey != null) {
            try {
                KeyLocator locator = new KeyLocator(){

                    public Key getKey(String kid) throws KeyManagementException {
                        return KeyUtils.publicKeyFromString(realmPublicKey);
                    }

                    public void refreshKeyCache() {
                    }
                };
                SamlProtocolUtils.verifyRedirectSignature((SAMLDocumentHolder)documentHolder, (KeyLocator)locator, encodedParams, (String)(samlResponse != null ? "SAMLResponse" : "SAMLRequest"));
            }
            catch (VerificationException e) {
                throw new IOException(e);
            }
        }
        return documentHolder;
    }

    public static AuthnRequestType createLoginRequestDocument(String issuer, String assertionConsumerURL, URI destination) {
        try {
            SAML2Request samlReq = new SAML2Request();
            AuthnRequestType loginReq = samlReq.createAuthnRequestType(UUID.randomUUID().toString(), assertionConsumerURL, destination == null ? null : destination.toString(), issuer);
            return loginReq;
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void execute(Step ... steps) {
        this.executeAndTransform((CloseableHttpResponse resp) -> null, Arrays.asList(steps));
    }

    public void execute(List<Step> steps) {
        this.executeAndTransform((CloseableHttpResponse resp) -> null, steps);
    }

    public <T> T executeAndTransform(ResultExtractor<T> resultTransformer, Step ... steps) {
        return this.executeAndTransform(resultTransformer, Arrays.asList(steps));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeAndTransform(ResultExtractor<T> resultTransformer, List<Step> steps) {
        CloseableHttpResponse currentResponse = null;
        URI currentUri = URI.create("about:blank");
        this.strategy.setRedirectable(true);
        try (CloseableHttpClient client = this.createHttpClientBuilderInstance().setRedirectStrategy((RedirectStrategy)this.strategy).build();){
            for (int i = 0; i < steps.size(); ++i) {
                Runnable afterChecker;
                Runnable beforeChecker;
                Step s = steps.get(i);
                LOG.infof("Running step %d: %s", (Object)i, s.getClass());
                CloseableHttpResponse origResponse = currentResponse;
                HttpUriRequest request = s.perform(client, currentUri, origResponse, this.context);
                if (request == null) {
                    LOG.info((Object)"Last step returned no request, continuing with next step.");
                    continue;
                }
                if (i < steps.size() - 1 && steps.get(i + 1) instanceof DoNotFollowRedirectStep) {
                    LOG.debugf("Disabling following redirects", new Object[0]);
                    this.strategy.setRedirectable(false);
                    ++i;
                } else {
                    this.strategy.setRedirectable(true);
                }
                LOG.infof("Executing HTTP request to %s", (Object)request.getURI());
                if (s instanceof StepWithCheckers && (beforeChecker = ((StepWithCheckers)((Object)s)).getBeforeStepChecker()) != null) {
                    beforeChecker.run();
                }
                currentResponse = client.execute(request, (HttpContext)this.context);
                if (s instanceof StepWithCheckers && (afterChecker = ((StepWithCheckers)((Object)s)).getAfterStepChecker()) != null) {
                    afterChecker.run();
                }
                currentUri = request.getURI();
                List locations = this.context.getRedirectLocations();
                if (locations != null && !locations.isEmpty()) {
                    currentUri = (URI)locations.get(locations.size() - 1);
                }
                LOG.infof("Landed to %s", (Object)currentUri);
                if (currentResponse == origResponse || origResponse == null) continue;
                origResponse.close();
            }
            LOG.info((Object)"Going to extract response");
            T t = resultTransformer.extract(currentResponse);
            return t;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public HttpClientContext getContext() {
        return this.context;
    }

    protected HttpClientBuilder createHttpClientBuilderInstance() {
        return HttpClientBuilder.create().evictIdleConnections(100L, TimeUnit.MILLISECONDS);
    }

    public static enum Binding {
        POST{

            @Override
            public SAMLDocumentHolder extractResponse(CloseableHttpResponse response, String realmPublicKey) throws IOException {
                Assert.assertThat((Object)response, Matchers.statusCodeIsHC(Response.Status.OK));
                String responsePage = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                response.close();
                return SamlClient.extractSamlResponseFromForm(responsePage);
            }

            public HttpPost createSamlUnsignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                return this.createSamlPostMessage(samlEndpoint, relayState, samlRequest, "SAMLRequest", null, null, null);
            }

            public HttpPost createSamlUnsignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                return this.createSamlPostMessage(samlEndpoint, relayState, samlRequest, "SAMLResponse", null, null, null);
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return this.createSamlSignedResponse(samlEndpoint, relayState, samlRequest, realmPrivateKey, realmPublicKey, null);
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                return null;
            }

            @Override
            public String extractRelayState(CloseableHttpResponse response) throws IOException {
                Assert.assertThat((Object)response, Matchers.statusCodeIsHC(Response.Status.OK));
                String responsePage = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                response.close();
                return SamlClient.extractSamlRelayStateFromForm(responsePage);
            }

            public HttpPost createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return this.createSamlSignedRequest(samlEndpoint, relayState, samlRequest, realmPrivateKey, realmPublicKey, null);
            }

            public HttpPost createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                return this.createSamlPostMessage(samlEndpoint, relayState, samlRequest, "SAMLRequest", realmPrivateKey, realmPublicKey, certificateStr);
            }

            private HttpPost createSamlPostMessage(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String messageType, String privateKeyStr, String publicKeyStr, String certificateStr) {
                UrlEncodedFormEntity formEntity;
                HttpPost post = new HttpPost(samlEndpoint);
                LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
                try {
                    BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
                    if (privateKeyStr != null && publicKeyStr != null) {
                        PrivateKey privateKey = KeyUtils.privateKeyFromString(privateKeyStr);
                        PublicKey publicKey = KeyUtils.publicKeyFromString(publicKeyStr);
                        X509Certificate cert = PemUtils.decodeCertificate((String)certificateStr);
                        binding.signatureAlgorithm(SignatureAlgorithm.RSA_SHA256).signWith(org.keycloak.common.util.KeyUtils.createKeyId((Key)privateKey), privateKey, publicKey, cert).signDocument();
                    }
                    parameters.add(new BasicNameValuePair(messageType, binding.postBinding(samlRequest).encoded()));
                }
                catch (IOException | ConfigurationException | ProcessingException ex) {
                    throw new RuntimeException(ex);
                }
                if (relayState != null) {
                    parameters.add(new BasicNameValuePair("RelayState", relayState));
                }
                try {
                    formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                post.setEntity((HttpEntity)formEntity);
                return post;
            }

            @Override
            public URI getBindingUri() {
                return JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri();
            }
        }
        ,
        REDIRECT{

            @Override
            public SAMLDocumentHolder extractResponse(CloseableHttpResponse response, String realmPublicKey) throws IOException {
                Assert.assertThat((Object)response, Matchers.statusCodeIsHC(Response.Status.FOUND));
                String location = response.getFirstHeader("Location").getValue();
                response.close();
                return SamlClient.extractSamlResponseFromRedirect(location, realmPublicKey);
            }

            public HttpGet createSamlUnsignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                try {
                    URI requestURI = new BaseSAML2BindingBuilder().relayState(relayState).redirectBinding(samlRequest).requestURI(samlEndpoint.toString());
                    return new HttpGet(requestURI);
                }
                catch (IOException | ConfigurationException | ProcessingException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public URI getBindingUri() {
                return JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri();
            }

            @Override
            public HttpUriRequest createSamlUnsignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                try {
                    URI responseURI = new BaseSAML2BindingBuilder().relayState(relayState).redirectBinding(samlRequest).responseURI(samlEndpoint.toString());
                    return new HttpGet(responseURI);
                }
                catch (IOException | ConfigurationException | ProcessingException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return this.createSamlSignedResponse(samlEndpoint, relayState, samlRequest, realmPrivateKey, realmPublicKey, null);
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                try {
                    BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
                    if (realmPrivateKey != null && realmPublicKey != null) {
                        PrivateKey privateKey = KeyUtils.privateKeyFromString(realmPrivateKey);
                        PublicKey publicKey = KeyUtils.publicKeyFromString(realmPublicKey);
                        X509Certificate cert = PemUtils.decodeCertificate((String)certificateStr);
                        binding.signatureAlgorithm(SignatureAlgorithm.RSA_SHA256).signWith(org.keycloak.common.util.KeyUtils.createKeyId((Key)privateKey), privateKey, publicKey, cert).signDocument();
                    }
                    binding.relayState(relayState);
                    return new HttpGet(binding.redirectBinding(samlRequest).responseURI(samlEndpoint.toString()));
                }
                catch (IOException | ConfigurationException | ProcessingException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public String extractRelayState(CloseableHttpResponse response) throws IOException {
                Assert.assertThat((Object)response, Matchers.statusCodeIsHC(Response.Status.FOUND));
                String location = response.getFirstHeader("Location").getValue();
                response.close();
                return SamlClient.extractRelayStateFromRedirect(location);
            }

            @Override
            public HttpUriRequest createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String privateKeyStr, String publicKeyStr) {
                return this.createSamlSignedRequest(samlEndpoint, relayState, samlRequest, privateKeyStr, publicKeyStr, null);
            }

            @Override
            public HttpUriRequest createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String privateKeyStr, String publicKeyStr, String certificateStr) {
                try {
                    BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder().relayState(relayState);
                    if (privateKeyStr != null && publicKeyStr != null) {
                        PrivateKey privateKey = KeyUtils.privateKeyFromString(privateKeyStr);
                        PublicKey publicKey = KeyUtils.publicKeyFromString(publicKeyStr);
                        X509Certificate cert = PemUtils.decodeCertificate((String)certificateStr);
                        binding.signatureAlgorithm(SignatureAlgorithm.RSA_SHA256).signWith(org.keycloak.common.util.KeyUtils.createKeyId((Key)privateKey), privateKey, publicKey, cert).signDocument();
                    }
                    return new HttpGet(binding.redirectBinding(samlRequest).requestURI(samlEndpoint.toString()));
                }
                catch (IOException | ConfigurationException | ProcessingException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        ,
        SOAP{
            private static final String NS_PREFIX_PROFILE_ECP = "ecp";
            private static final String NS_PREFIX_SAML_PROTOCOL = "samlp";
            private static final String NS_PREFIX_SAML_ASSERTION = "saml";
            private static final String NS_PREFIX_PAOS_BINDING = "paos";

            @Override
            public SAMLDocumentHolder extractResponse(CloseableHttpResponse response, String realmPublicKey) throws IOException {
                Assert.assertThat((Object)response, Matchers.statusCodeIsHC(200));
                MessageFactory messageFactory = null;
                try {
                    messageFactory = MessageFactory.newInstance();
                    SOAPMessage soapMessage = messageFactory.createMessage(null, response.getEntity().getContent());
                    SOAPBody soapBody = soapMessage.getSOAPBody();
                    Node authnRequestNode = soapBody.getFirstChild();
                    org.w3c.dom.Document document = DocumentUtil.createDocument();
                    document.appendChild(document.importNode(authnRequestNode, true));
                    SAMLParser samlParser = SAMLParser.getInstance();
                    JAXPValidationUtil.checkSchemaValidation((Node)document);
                    SAML2Object responseType = (SAML2Object)samlParser.parse((Node)document);
                    return new SAMLDocumentHolder(responseType, document);
                }
                catch (SOAPException | ConfigurationException | ParsingException | ProcessingException e) {
                    throw new RuntimeException(e);
                }
            }

            private void createEcpRequestHeader(SOAPEnvelope envelope, SamlDeployment deployment) throws SOAPException {
                SOAPHeader headers = envelope.getHeader();
                SOAPHeaderElement ecpRequestHeader = headers.addHeaderElement(envelope.createQName(JBossSAMLConstants.REQUEST.get(), NS_PREFIX_PROFILE_ECP));
                ecpRequestHeader.setMustUnderstand(true);
                ecpRequestHeader.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                ecpRequestHeader.addAttribute(envelope.createName("ProviderName"), deployment.getEntityID());
                ecpRequestHeader.addAttribute(envelope.createName("IsPassive"), "0");
                ecpRequestHeader.addChildElement(envelope.createQName("Issuer", NS_PREFIX_SAML_ASSERTION)).setValue(deployment.getEntityID());
                ecpRequestHeader.addChildElement(envelope.createQName("IDPList", NS_PREFIX_SAML_PROTOCOL)).addChildElement(envelope.createQName("IDPEntry", NS_PREFIX_SAML_PROTOCOL)).addAttribute(envelope.createName("ProviderID"), deployment.getIDP().getEntityID()).addAttribute(envelope.createName("Name"), deployment.getIDP().getEntityID()).addAttribute(envelope.createName("Loc"), deployment.getIDP().getSingleSignOnService().getRequestBindingUrl());
            }

            private void createPaosRequestHeader(SOAPEnvelope envelope, SamlDeployment deployment) throws SOAPException {
                SOAPHeader headers = envelope.getHeader();
                SOAPHeaderElement paosRequestHeader = headers.addHeaderElement(envelope.createQName(JBossSAMLConstants.REQUEST.get(), NS_PREFIX_PAOS_BINDING));
                paosRequestHeader.setMustUnderstand(true);
                paosRequestHeader.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                paosRequestHeader.addAttribute(envelope.createName("service"), JBossSAMLURIConstants.ECP_PROFILE.get());
                paosRequestHeader.addAttribute(envelope.createName("responseConsumerURL"), this.getResponseConsumerUrl(deployment));
            }

            private String getResponseConsumerUrl(SamlDeployment deployment) {
                return deployment.getIDP() == null || deployment.getIDP().getSingleSignOnService() == null || deployment.getIDP().getSingleSignOnService().getAssertionConsumerServiceUrl() == null ? null : deployment.getIDP().getSingleSignOnService().getAssertionConsumerServiceUrl().toString();
            }

            @Override
            public HttpUriRequest createSamlUnsignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                return this.createSamlSignedRequest(samlEndpoint, relayState, samlRequest, null, null, null);
            }

            @Override
            public HttpUriRequest createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return this.createSamlSignedRequest(samlEndpoint, relayState, samlRequest, realmPrivateKey, realmPublicKey, null);
            }

            @Override
            public HttpUriRequest createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
                if (realmPrivateKey != null && realmPublicKey != null) {
                    PrivateKey privateKey = KeyUtils.privateKeyFromString(realmPrivateKey);
                    PublicKey publicKey = KeyUtils.publicKeyFromString(realmPublicKey);
                    X509Certificate cert = PemUtils.decodeCertificate((String)certificateStr);
                    binding.signatureAlgorithm(SignatureAlgorithm.RSA_SHA256).signWith(org.keycloak.common.util.KeyUtils.createKeyId((Key)privateKey), privateKey, publicKey, cert).signDocument();
                    try {
                        samlRequest = binding.postBinding(samlRequest).getDocument();
                    }
                    catch (ProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                MessageFactory messageFactory = null;
                try {
                    messageFactory = MessageFactory.newInstance();
                    SOAPMessage message = messageFactory.createMessage();
                    SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
                    envelope.addNamespaceDeclaration(NS_PREFIX_SAML_ASSERTION, JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    envelope.addNamespaceDeclaration(NS_PREFIX_SAML_PROTOCOL, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
                    envelope.addNamespaceDeclaration(NS_PREFIX_PAOS_BINDING, JBossSAMLURIConstants.PAOS_BINDING.get());
                    envelope.addNamespaceDeclaration(NS_PREFIX_PROFILE_ECP, JBossSAMLURIConstants.ECP_PROFILE.get());
                    SamlDeployment deployment = SamlUtils.getSamlDeploymentForClient("ecp-sp");
                    this.createPaosRequestHeader(envelope, deployment);
                    this.createEcpRequestHeader(envelope, deployment);
                    SOAPBody body = envelope.getBody();
                    body.addDocument(samlRequest);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)outputStream);
                    HttpPost post = new HttpPost(samlEndpoint);
                    post.setEntity((HttpEntity)new ByteArrayEntity(outputStream.toByteArray(), ContentType.TEXT_XML));
                    return post;
                }
                catch (IOException | SOAPException | ParsingException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public URI getBindingUri() {
                return null;
            }

            @Override
            public HttpUriRequest createSamlUnsignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                return null;
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return null;
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                return null;
            }

            @Override
            public String extractRelayState(CloseableHttpResponse response) throws IOException {
                return null;
            }
        }
        ,
        ARTIFACT_RESPONSE{

            private org.w3c.dom.Document extractSoapMessage(CloseableHttpResponse response) throws IOException {
                ByteArrayInputStream bais = new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                org.w3c.dom.Document soapBody = Soap.extractSoapMessage((InputStream)bais);
                response.close();
                return soapBody;
            }

            @Override
            public SAMLDocumentHolder extractResponse(CloseableHttpResponse response, String realmPublicKey) throws IOException {
                Assert.assertThat((Object)response, Matchers.statusCodeIsHC(Response.Status.OK));
                org.w3c.dom.Document soapBodyContents = this.extractSoapMessage(response);
                SAMLDocumentHolder samlDoc = null;
                try {
                    samlDoc = SAML2Request.getSAML2ObjectFromDocument((org.w3c.dom.Document)soapBodyContents);
                }
                catch (ParsingException | ProcessingException e) {
                    throw new RuntimeException("Unable to get documentHolder from soapBodyResponse: " + DocumentUtil.asString((org.w3c.dom.Document)soapBodyContents));
                }
                if (!(samlDoc.getSamlObject() instanceof ArtifactResponseType)) {
                    throw new RuntimeException("Message received from ArtifactResolveService is not an ArtifactResponseMessage");
                }
                ArtifactResponseType art = (ArtifactResponseType)samlDoc.getSamlObject();
                try {
                    Object artifactResponseContent = art.getAny();
                    if (artifactResponseContent instanceof ResponseType) {
                        org.w3c.dom.Document doc = SAML2Request.convert((ResponseType)((ResponseType)artifactResponseContent));
                        return new SAMLDocumentHolder((SAML2Object)((ResponseType)artifactResponseContent), doc);
                    }
                    if (artifactResponseContent instanceof RequestAbstractType) {
                        org.w3c.dom.Document doc = SAML2Request.convert((RequestAbstractType)((RequestAbstractType)art.getAny()));
                        return new SAMLDocumentHolder((SAML2Object)((RequestAbstractType)artifactResponseContent), doc);
                    }
                    throw new RuntimeException("Can not recognise message contained in ArtifactResponse");
                }
                catch (ConfigurationException | ParsingException | ProcessingException e) {
                    throw new RuntimeException("Can not obtain document from artifact response: " + DocumentUtil.asString((org.w3c.dom.Document)soapBodyContents));
                }
            }

            @Override
            public HttpUriRequest createSamlUnsignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                return null;
            }

            @Override
            public HttpUriRequest createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return null;
            }

            @Override
            public HttpUriRequest createSamlSignedRequest(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                return null;
            }

            @Override
            public URI getBindingUri() {
                return JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri();
            }

            @Override
            public HttpUriRequest createSamlUnsignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest) {
                return null;
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey) {
                return null;
            }

            @Override
            public HttpUriRequest createSamlSignedResponse(URI samlEndpoint, String relayState, org.w3c.dom.Document samlRequest, String realmPrivateKey, String realmPublicKey, String certificateStr) {
                return null;
            }

            @Override
            public String extractRelayState(CloseableHttpResponse response) throws IOException {
                return null;
            }
        };


        public abstract SAMLDocumentHolder extractResponse(CloseableHttpResponse var1, String var2) throws IOException;

        public SAMLDocumentHolder extractResponse(CloseableHttpResponse response) throws IOException {
            return this.extractResponse(response, null);
        }

        public abstract HttpUriRequest createSamlUnsignedRequest(URI var1, String var2, org.w3c.dom.Document var3);

        public abstract HttpUriRequest createSamlSignedRequest(URI var1, String var2, org.w3c.dom.Document var3, String var4, String var5);

        public abstract HttpUriRequest createSamlSignedRequest(URI var1, String var2, org.w3c.dom.Document var3, String var4, String var5, String var6);

        public abstract URI getBindingUri();

        public abstract HttpUriRequest createSamlUnsignedResponse(URI var1, String var2, org.w3c.dom.Document var3);

        public abstract HttpUriRequest createSamlSignedResponse(URI var1, String var2, org.w3c.dom.Document var3, String var4, String var5);

        public abstract HttpUriRequest createSamlSignedResponse(URI var1, String var2, org.w3c.dom.Document var3, String var4, String var5, String var6);

        public abstract String extractRelayState(CloseableHttpResponse var1) throws IOException;
    }

    public static class RedirectStrategyWithSwitchableFollowRedirect
    extends LaxRedirectStrategy {
        public boolean redirectable = true;

        protected boolean isRedirectable(String method) {
            return this.redirectable && super.isRedirectable(method);
        }

        public void setRedirectable(boolean redirectable) {
            this.redirectable = redirectable;
        }
    }

    public static final class DoNotFollowRedirectStep
    implements Step {
        @Override
        public HttpUriRequest perform(CloseableHttpClient client, URI uri, CloseableHttpResponse response, HttpClientContext context) throws Exception {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ResultExtractor<T> {
        public T extract(CloseableHttpResponse var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Step {
        public HttpUriRequest perform(CloseableHttpClient var1, URI var2, CloseableHttpResponse var3, HttpClientContext var4) throws Exception;
    }
}

