/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.KerberosEmbeddedServer;
import org.keycloak.testsuite.client.resources.TestingResource;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestConfiguration;
import org.keycloak.util.ldap.LDAPEmbeddedServer;

public class KerberosRule
extends LDAPRule {
    private static final Logger log = Logger.getLogger(KerberosRule.class);
    private final String configLocation;
    private final String kerberosRealm;

    public KerberosRule(String configLocation, String kerberosRealm) {
        this.configLocation = configLocation;
        this.kerberosRealm = kerberosRealm;
        String krb5ConfPath = this.getKrb5ConfPath();
        System.setProperty("java.security.krb5.conf", krb5ConfPath);
    }

    private String getKrb5ConfPath() {
        URL krb5ConfURL = LDAPTestConfiguration.class.getResource("/kerberos/test-krb5.conf");
        String krb5ConfPath = new File(krb5ConfURL.getFile()).getAbsolutePath();
        log.info((Object)("Krb5.conf file location is: " + krb5ConfPath));
        return krb5ConfPath;
    }

    public void setKrb5ConfPath(TestingResource testingResource) {
        String krb5ConfPath = this.getKrb5ConfPath();
        System.setProperty("java.security.krb5.conf", krb5ConfPath);
        testingResource.setKrb5ConfFile(krb5ConfPath);
    }

    @Override
    protected String getConnectionPropertiesLocation() {
        return this.configLocation;
    }

    public String getKerberosRealm() {
        return this.kerberosRealm;
    }

    @Override
    protected LDAPEmbeddedServer createServer() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty("ldap.dsf", "mem");
        KerberosEmbeddedServer.configureDefaultPropertiesForRealm((String)this.kerberosRealm, (Properties)defaultProperties);
        if ("KEYCLOAK.ORG".equals(this.kerberosRealm)) {
            defaultProperties.setProperty("ldap.ldif", "classpath:kerberos/users-kerberos.ldif");
        } else if ("KC2.COM".equals(this.kerberosRealm)) {
            defaultProperties.setProperty("ldap.ldif", "classpath:kerberos/users-kerberos-kc2.ldif");
        }
        return new KerberosEmbeddedServer(defaultProperties);
    }

    public boolean isCaseSensitiveLogin() {
        return this.ldapTestConfiguration.isCaseSensitiveLogin();
    }

    public boolean isStartEmbeddedLdapServer() {
        return this.ldapTestConfiguration.isStartEmbeddedLdapServer();
    }
}

