/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.gargoylesoftware.htmlunit.WebClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.drone.webdriver.htmlunit.DroneHtmlUnitDriver;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class BrowserTabUtil
implements AutoCloseable {
    private WebDriver driver;
    private JavascriptExecutor jsExecutor;
    private List<String> tabs;
    private static List<BrowserTabUtil> instances;

    private BrowserTabUtil(WebDriver driver) {
        this.driver = driver;
        if (!(driver instanceof JavascriptExecutor)) {
            throw new RuntimeException("WebDriver must be instance of JavascriptExecutor");
        }
        this.jsExecutor = (JavascriptExecutor)driver;
        if (driver instanceof HtmlUnitDriver) {
            WebClient client = ((DroneHtmlUnitDriver)driver).getWebClient();
            client.getOptions().setThrowExceptionOnScriptError(false);
            client.getOptions().setThrowExceptionOnFailingStatusCode(false);
        }
        this.tabs = new ArrayList<String>(driver.getWindowHandles());
    }

    public static BrowserTabUtil getInstanceAndSetEnv(WebDriver driver) {
        BrowserTabUtil instance;
        if (instances == null) {
            instances = new ArrayList<BrowserTabUtil>();
        }
        if ((instance = (BrowserTabUtil)instances.stream().filter(inst -> inst.getDriver().toString().equals(driver.toString())).findFirst().orElse(null)) == null) {
            instance = new BrowserTabUtil(driver);
            instances.add(instance);
        }
        return instance;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getActualWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public void switchToTab(String windowHandle) {
        this.driver.switchTo().window(windowHandle);
        WaitUtils.waitForPageToLoad();
    }

    public void switchToTab(int index) {
        this.assertValidIndex(index);
        this.switchToTab(this.tabs.get(index));
    }

    public void newTab(String url) {
        this.jsExecutor.executeScript("window.open(arguments[0]);", new Object[]{url});
        Set handles = this.driver.getWindowHandles();
        String tabHandle = handles.stream().filter(tab -> !this.tabs.contains(tab)).findFirst().orElse(null);
        if (handles.size() > this.tabs.size() + 1) {
            throw new RuntimeException("Too many window handles. You can only create a new one by this method.");
        }
        if (tabHandle == null) {
            throw new RuntimeException("Creating the new tab failed.");
        }
        this.tabs.add(tabHandle);
        this.switchToTab(tabHandle);
    }

    public void closeTab(int index) {
        this.assertValidIndex(index);
        if (index == 0 || this.getCountOfTabs() == 1) {
            throw new RuntimeException("You must not close the original tab.");
        }
        this.switchToTab(index);
        this.driver.close();
        this.tabs.remove(index);
        this.switchToTab(index - 1);
    }

    public int getCountOfTabs() {
        return this.tabs.size();
    }

    public void destroy() {
        for (int i = 1; i < this.getCountOfTabs(); ++i) {
            this.closeTab(i);
        }
        instances.removeIf(inst -> inst.getDriver().toString().equals(this.driver.toString()));
    }

    private boolean validIndex(int index) {
        return index >= 0 && this.tabs != null && index < this.tabs.size();
    }

    private void assertValidIndex(int index) {
        if (!this.validIndex(index)) {
            throw new IndexOutOfBoundsException("Invalid index of tab.");
        }
    }

    @Override
    public void close() {
        this.destroy();
    }
}

