/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.updaters.RoleScopeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;

public class UserAttributeUpdater
extends ServerResourceUpdater<UserAttributeUpdater, UserResource, UserRepresentation> {
    private final RealmResource realmResource;

    public static UserAttributeUpdater forUserByUsername(Keycloak adminClient, String realm, String userName) {
        return UserAttributeUpdater.forUserByUsername(adminClient.realm(realm), userName);
    }

    public static UserAttributeUpdater forUserByUsername(RealmResource realm, String userName) {
        UsersResource users = realm.users();
        List foundUsers = users.search(userName).stream().filter(ur -> userName.equalsIgnoreCase(ur.getUsername())).collect(Collectors.toList());
        Assert.assertThat(foundUsers, (Matcher)Matchers.hasSize((int)1));
        UserResource userRes = users.get(((UserRepresentation)foundUsers.get(0)).getId());
        return new UserAttributeUpdater(userRes, realm);
    }

    public UserAttributeUpdater(UserResource resource) {
        this(resource, null);
    }

    public UserAttributeUpdater(UserResource resource, RealmResource realmResource) {
        super(resource, () -> {
            UserRepresentation r = resource.toRepresentation();
            r.setGroups(resource.groups().stream().map(GroupRepresentation::getPath).collect(Collectors.toList()));
            return r;
        }, arg_0 -> ((UserResource)resource).update(arg_0));
        if (((UserRepresentation)this.rep).getAttributes() == null) {
            ((UserRepresentation)this.rep).setAttributes(new HashMap());
        }
        this.realmResource = realmResource;
    }

    @Override
    protected void performUpdate(UserRepresentation from, UserRepresentation to) {
        super.performUpdate(from, to);
        UserAttributeUpdater.updateViaAddRemove(from.getGroups(), to.getGroups(), this::getConversionForGroupPathToId, arg_0 -> ((UserResource)((UserResource)this.resource)).joinGroup(arg_0), arg_0 -> ((UserResource)((UserResource)this.resource)).leaveGroup(arg_0));
    }

    private Function<String, String> getConversionForGroupPathToId() {
        if (this.realmResource == null) {
            return String::toString;
        }
        Map<String, String> humanIdToIdMap = this.realmResource.groups().groups().stream().collect(Collectors.toMap(GroupRepresentation::getPath, GroupRepresentation::getId));
        return humanIdToIdMap::get;
    }

    public UserAttributeUpdater setAttribute(String name, List<String> value) {
        ((UserRepresentation)this.rep).getAttributes().put(name, value);
        return this;
    }

    public UserAttributeUpdater setAttribute(String name, String ... values) {
        ((UserRepresentation)this.rep).getAttributes().put(name, Arrays.asList(values));
        return this;
    }

    public UserAttributeUpdater removeAttribute(String name) {
        ((UserRepresentation)this.rep).getAttributes().put(name, null);
        return this;
    }

    public UserAttributeUpdater setEmailVerified(Boolean emailVerified) {
        ((UserRepresentation)this.rep).setEmailVerified(emailVerified);
        return this;
    }

    public UserAttributeUpdater setRequiredActions(UserModel.RequiredAction ... requiredAction) {
        ((UserRepresentation)this.rep).setRequiredActions(Arrays.stream(requiredAction).map(action -> action.name()).collect(Collectors.toList()));
        return this;
    }

    public RoleScopeUpdater realmRoleScope() {
        return new RoleScopeUpdater(((UserResource)this.resource).roles().realmLevel());
    }

    public RoleScopeUpdater clientRoleScope(String clientUUID) {
        return new RoleScopeUpdater(((UserResource)this.resource).roles().clientLevel(clientUUID));
    }

    public UserAttributeUpdater setGroups(String ... groups) {
        ((UserRepresentation)this.rep).setGroups(Arrays.asList(groups));
        return this;
    }
}

