/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;

public class ProtocolMappersUpdater
extends ServerResourceUpdater<ProtocolMappersUpdater, ProtocolMappersResource, List<ProtocolMapperRepresentation>> {
    public ProtocolMappersUpdater(ProtocolMappersResource resource) {
        super(resource, () -> ((ProtocolMappersResource)resource).getMappers(), null);
        this.updater = this::update;
    }

    public ProtocolMappersUpdater add(ProtocolMapperRepresentation ... representation) {
        ((List)this.rep).addAll(Arrays.asList(representation));
        return this;
    }

    public ProtocolMappersUpdater clear() {
        ((List)this.rep).clear();
        return this;
    }

    public ProtocolMappersUpdater remove(ProtocolMapperRepresentation representation) {
        ((List)this.rep).remove(representation);
        return this;
    }

    public ProtocolMappersUpdater removeById(String id) {
        Iterator it = ((List)this.rep).iterator();
        while (it.hasNext()) {
            ProtocolMapperRepresentation mapper = (ProtocolMapperRepresentation)it.next();
            if (!id.equals(mapper.getId())) continue;
            it.remove();
            break;
        }
        return this;
    }

    private void update(List<ProtocolMapperRepresentation> expectedMappers) {
        List currentMappers = ((ProtocolMappersResource)this.resource).getMappers();
        Set currentMapperIds = currentMappers.stream().map(ProtocolMapperRepresentation::getId).collect(Collectors.toSet());
        Set expectedMapperIds = expectedMappers.stream().map(ProtocolMapperRepresentation::getId).collect(Collectors.toSet());
        List toAdd = expectedMappers.stream().filter(mapper -> !currentMapperIds.contains(mapper.getId())).collect(Collectors.toList());
        Stream<ProtocolMapperRepresentation> toRemove = currentMappers.stream().filter(mapper -> !expectedMapperIds.contains(mapper.getId()));
        ((ProtocolMappersResource)this.resource).createMapper(toAdd);
        toRemove.map(ProtocolMapperRepresentation::getId).forEach(arg_0 -> ((ProtocolMappersResource)((ProtocolMappersResource)this.resource)).delete(arg_0));
    }
}

