/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.io.Closeable;
import java.io.IOException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.IdentityProviderRepresentation;

public class IdentityProviderCreator
implements Closeable {
    private final IdentityProvidersResource resource;
    private final String alias;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityProviderCreator(RealmResource realmResource, IdentityProviderRepresentation rep) {
        this.resource = realmResource.identityProviders();
        this.alias = rep.getAlias();
        try (Response response = null;){
            response = this.resource.create(rep);
        }
    }

    public IdentityProvidersResource resource() {
        return this.resource;
    }

    public IdentityProviderResource identityProvider() {
        return this.resource().get(this.alias);
    }

    @Override
    public void close() throws IOException {
        try {
            this.resource.get(this.alias).remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

