/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.testsuite.updaters.ProtocolMappersUpdater;
import org.keycloak.testsuite.updaters.RoleScopeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;

public class ClientAttributeUpdater
extends ServerResourceUpdater<ClientAttributeUpdater, ClientResource, ClientRepresentation> {
    private final RealmResource realmResource;

    public static ClientAttributeUpdater forClient(Keycloak adminClient, String realm, String clientId) {
        RealmResource realmRes = adminClient.realm(realm);
        ClientsResource clients = realmRes.clients();
        List foundClients = clients.findByClientId(clientId);
        MatcherAssert.assertThat((Object)foundClients, (Matcher)Matchers.hasSize((int)1));
        ClientResource clientRes = clients.get(((ClientRepresentation)foundClients.get(0)).getId());
        return new ClientAttributeUpdater(clientRes, realmRes);
    }

    private ClientAttributeUpdater(ClientResource resource, RealmResource realmResource) {
        super(resource, () -> ((ClientResource)resource).toRepresentation(), arg_0 -> ((ClientResource)resource).update(arg_0));
        if (((ClientRepresentation)this.rep).getAttributes() == null) {
            ((ClientRepresentation)this.rep).setAttributes(new HashMap());
        }
        this.realmResource = realmResource;
    }

    @Override
    protected void performUpdate(ClientRepresentation from, ClientRepresentation to) {
        super.performUpdate(from, to);
        ClientAttributeUpdater.updateViaAddRemove(from.getDefaultClientScopes(), to.getDefaultClientScopes(), this::getConversionForScopeNameToId, arg_0 -> ((ClientResource)((ClientResource)this.resource)).addDefaultClientScope(arg_0), arg_0 -> ((ClientResource)((ClientResource)this.resource)).removeDefaultClientScope(arg_0));
        ClientAttributeUpdater.updateViaAddRemove(from.getOptionalClientScopes(), to.getOptionalClientScopes(), this::getConversionForScopeNameToId, arg_0 -> ((ClientResource)((ClientResource)this.resource)).addOptionalClientScope(arg_0), arg_0 -> ((ClientResource)((ClientResource)this.resource)).removeOptionalClientScope(arg_0));
    }

    private Function<String, String> getConversionForScopeNameToId() {
        Map<String, String> scopeNameToIdMap = this.realmResource.clientScopes().findAll().stream().collect(Collectors.toMap(ClientScopeRepresentation::getName, ClientScopeRepresentation::getId));
        return scopeNameToIdMap::get;
    }

    public ClientAttributeUpdater setClientId(String clientId) {
        ((ClientRepresentation)this.rep).setClientId(clientId);
        return this;
    }

    public ClientAttributeUpdater setAttribute(String name, String value) {
        ((ClientRepresentation)this.rep).getAttributes().put(name, value);
        if (value != null && !((ClientRepresentation)this.origRep).getAttributes().containsKey(name)) {
            ((ClientRepresentation)this.origRep).getAttributes().put(name, null);
        }
        return this;
    }

    public ClientAttributeUpdater setRedirectUris(List<String> values) {
        ((ClientRepresentation)this.rep).setRedirectUris(values);
        return this;
    }

    public ClientAttributeUpdater filterRedirectUris(Predicate<String> filter) {
        ((ClientRepresentation)this.rep).setRedirectUris(((ClientRepresentation)this.rep).getRedirectUris().stream().filter(filter).collect(Collectors.toList()));
        return this;
    }

    public ClientAttributeUpdater removeAttribute(String name) {
        ((ClientRepresentation)this.rep).getAttributes().remove(name);
        return this;
    }

    public ClientAttributeUpdater setConsentRequired(Boolean consentRequired) {
        ((ClientRepresentation)this.rep).setConsentRequired(consentRequired);
        return this;
    }

    public ClientAttributeUpdater setFrontchannelLogout(Boolean frontchannelLogout) {
        ((ClientRepresentation)this.rep).setFrontchannelLogout(frontchannelLogout);
        return this;
    }

    public ClientAttributeUpdater setFullScopeAllowed(Boolean fullScopeAllowed) {
        ((ClientRepresentation)this.rep).setFullScopeAllowed(fullScopeAllowed);
        return this;
    }

    public ClientAttributeUpdater setDefaultClientScopes(List<String> defaultClientScopes) {
        ((ClientRepresentation)this.rep).setDefaultClientScopes(defaultClientScopes);
        return this;
    }

    public ClientAttributeUpdater setOptionalClientScopes(List<String> optionalClientScopes) {
        ((ClientRepresentation)this.rep).setOptionalClientScopes(optionalClientScopes);
        return this;
    }

    public ProtocolMappersUpdater protocolMappers() {
        return new ProtocolMappersUpdater(((ClientResource)this.resource).getProtocolMappers());
    }

    public RoleScopeUpdater realmRoleScope() {
        return new RoleScopeUpdater(((ClientResource)this.resource).getScopeMappings().realmLevel());
    }

    public RoleScopeUpdater clientRoleScope(String clientUUID) {
        return new RoleScopeUpdater(((ClientResource)this.resource).getScopeMappings().clientLevel(clientUUID));
    }

    public ClientAttributeUpdater setAdminUrl(String adminUrl) {
        ((ClientRepresentation)this.rep).setAdminUrl(adminUrl);
        return this;
    }

    public ClientAttributeUpdater addDefaultClientScope(String clientScope) {
        ((ClientRepresentation)this.rep).getDefaultClientScopes().add(clientScope);
        return this;
    }

    public ClientAttributeUpdater setDirectAccessGrantsEnabled(Boolean directAccessGranted) {
        ((ClientRepresentation)this.rep).setDirectAccessGrantsEnabled(directAccessGranted);
        return this;
    }
}

