/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages.social;

import org.keycloak.testsuite.pages.social.AbstractSocialLoginPage;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OpenShiftLoginPage
extends AbstractSocialLoginPage {
    @FindBy(name="username")
    private WebElement usernameInput;
    @FindBy(name="password")
    private WebElement passwordInput;
    private String userLoginLinkTitle;
    private WebElement userLoginLink;

    @Override
    public void login(String user, String password) {
        if (this.userLoginLinkTitle != null) {
            this.setUserLoginLink(this.userLoginLinkTitle);
            if (this.userLoginLink != null) {
                UIUtils.clickLink(this.userLoginLink);
            }
        }
        this.usernameInput.sendKeys(new CharSequence[]{user});
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.passwordInput.sendKeys(new CharSequence[]{Keys.RETURN});
    }

    public void setUserLoginLinkTitle(String title) {
        this.userLoginLinkTitle = title;
    }

    private void setUserLoginLink(String linkAttrTitle) {
        try {
            this.userLoginLink = this.driver.findElement(By.xpath((String)("//a[contains(@title,'" + linkAttrTitle + "')]")));
        }
        catch (NoSuchElementException ex) {
            this.log.error((Object)("No link with title: '" + linkAttrTitle + "' found on page. If you use the OPENSHIFT4_KUBE_ADMIN provider, set property loginBtnTitle in properties file to an existing title on the page to fix this error."));
        }
    }
}

