/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages.social;

import org.keycloak.testsuite.pages.social.AbstractSocialLoginPage;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class InstagramLoginPage
extends AbstractSocialLoginPage {
    @FindBy(name="username")
    private WebElement usernameInput;
    @FindBy(name="password")
    private WebElement passwordInput;
    @FindBy(xpath="//button[text()='Save Info']")
    private WebElement saveInfoBtn;
    @FindBy(xpath="//button[text()='Authorize']")
    private WebElement authorizeBtn;
    @FindBy(xpath="//button[text()='Continue']")
    private WebElement continueBtn;

    @Override
    public void login(String user, String password) {
        try {
            this.usernameInput.clear();
            this.usernameInput.sendKeys(new CharSequence[]{user});
            this.passwordInput.sendKeys(new CharSequence[]{password});
            this.passwordInput.sendKeys(new CharSequence[]{Keys.RETURN});
            WaitUtils.pause(2000L);
            try {
                this.saveInfoBtn.click();
            }
            catch (NoSuchElementException e) {
                this.log.info((Object)"'Save Info' button not found, ignoring");
                WaitUtils.pause(2000L);
            }
        }
        catch (NoSuchElementException e) {
            this.log.info((Object)"Instagram is already logged in, just confirmation is expected");
        }
        try {
            this.continueBtn.click();
        }
        catch (NoSuchElementException e) {
            this.log.info((Object)"'Continue' button not found, trying 'Authorize'...");
            this.authorizeBtn.click();
        }
    }
}

