/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.keycloak.testsuite.auth.page.AccountFields;
import org.keycloak.testsuite.auth.page.PasswordFields;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class RegisterPage
extends AbstractPage {
    @Page
    private AccountFields.AccountErrors accountErrors;
    @Page
    private PasswordFields.PasswordErrors passwordErrors;
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="password-confirm")
    private WebElement passwordConfirmInput;
    @FindBy(id="department")
    private WebElement departmentInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginAlertErrorMessage;
    @FindBy(className="instruction")
    private WebElement loginInstructionMessage;
    @FindBy(linkText="\u00ab Back to Login")
    private WebElement backToLoginLink;

    public void register(String firstName, String lastName, String email, String username, String password, String passwordConfirm) {
        this.register(firstName, lastName, email, username, password, passwordConfirm, null);
    }

    public void register(String firstName, String lastName, String email, String username, String password, String passwordConfirm, String department) {
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        this.emailInput.clear();
        if (email != null) {
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        this.usernameInput.clear();
        if (username != null) {
            this.usernameInput.sendKeys(new CharSequence[]{username});
        }
        this.passwordInput.clear();
        if (password != null) {
            this.passwordInput.sendKeys(new CharSequence[]{password});
        }
        this.passwordConfirmInput.clear();
        if (passwordConfirm != null) {
            this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        }
        if (this.isDepartmentPresent()) {
            this.departmentInput.clear();
            if (department != null) {
                this.departmentInput.sendKeys(new CharSequence[]{department});
            }
        }
        this.submitButton.click();
    }

    public void registerWithEmailAsUsername(String firstName, String lastName, String email, String password, String passwordConfirm) {
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        this.emailInput.clear();
        if (email != null) {
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        try {
            this.usernameInput.clear();
            Assert.fail((String)"Form must be without username field");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.passwordInput.clear();
        if (password != null) {
            this.passwordInput.sendKeys(new CharSequence[]{password});
        }
        this.passwordConfirmInput.clear();
        if (passwordConfirm != null) {
            this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        }
        this.submitButton.click();
    }

    public void clickBackToLogin() {
        this.backToLoginLink.click();
    }

    public String getAlertError() {
        try {
            return UIUtils.getTextFromElement(this.loginAlertErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getInstruction() {
        try {
            return UIUtils.getTextFromElement(this.loginInstructionMessage);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public String getLabelForField(String fieldId) {
        return this.driver.findElement(By.cssSelector((String)("label[for=" + fieldId + "]"))).getText();
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public String getPasswordConfirm() {
        return this.passwordConfirmInput.getAttribute("value");
    }

    public String getDepartment() {
        return this.departmentInput.getAttribute("value");
    }

    public boolean isDepartmentEnabled() {
        return this.departmentInput.isEnabled();
    }

    public boolean isDepartmentPresent() {
        try {
            return this.driver.findElement(By.id((String)"department")).isDisplayed();
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    @Override
    public boolean isCurrent() {
        return PageUtils.getPageTitle(this.driver).equals("Register");
    }

    public AccountFields.AccountErrors getInputAccountErrors() {
        return this.accountErrors;
    }

    public PasswordFields.PasswordErrors getInputPasswordErrors() {
        return this.passwordErrors;
    }

    @Override
    public void open() {
        this.oauth.openRegistrationForm();
        this.assertCurrent();
    }

    public void openWithLoginHint(String loginHint) {
        this.oauth.addCustomParameter("login_hint", loginHint).openRegistrationForm();
        this.assertCurrent();
    }
}

