/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PasswordPage
extends LanguageComboboxAwarePage {
    @ArquillianResource
    protected OAuthClient oauth;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="input-error-password")
    private WebElement passwordError;
    @FindBy(name="login")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(linkText="Forgot Password?")
    private WebElement resetPasswordLink;

    public void login(String password) {
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.submitButton.click();
    }

    public void clickResetPassword() {
        this.resetPasswordLink.click();
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public String getPasswordError() {
        try {
            return UIUtils.getTextFromElement(this.passwordError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getError() {
        try {
            return UIUtils.getTextFromElement(this.loginErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean isCurrent() {
        String realm = "test";
        return this.isCurrent(realm);
    }

    public boolean isCurrent(String realm) {
        try {
            this.driver.findElement(By.id((String)"username"));
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            try {
                this.driver.findElement(By.id((String)"kc-attempted-username"));
                this.driver.findElement(By.id((String)"password"));
            }
            catch (NoSuchElementException nfe) {
                return false;
            }
            return true;
        }
    }

    @Override
    public void open() throws Exception {
        throw new UnsupportedOperationException();
    }
}

