/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.junit.Assert;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OAuth2DeviceVerificationPage
extends LanguageComboboxAwarePage {
    private static final String CONSENT_DENIED_MESSAGE = "Consent denied for connecting the device.";
    @FindBy(id="device-user-code")
    private WebElement userCodeInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement verifyErrorMessage;

    public void submit(String userCode) {
        this.userCodeInput.clear();
        if (userCode != null) {
            this.userCodeInput.sendKeys(new CharSequence[]{userCode});
        }
        this.submitButton.click();
    }

    public String getError() {
        return this.verifyErrorMessage != null ? this.verifyErrorMessage.getText() : null;
    }

    @Override
    public boolean isCurrent() {
        if (this.driver.getTitle().startsWith("Sign in to ")) {
            try {
                this.driver.findElement(By.id((String)"device-user-code"));
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void assertApprovedPage() {
        Assert.assertTrue((String)("Expected device approved page but was " + this.driver.getTitle() + " (" + this.driver.getCurrentUrl() + ")"), (boolean)this.isApprovedPage());
    }

    public void assertDeniedPage() {
        Assert.assertTrue((String)("Expected device denied page but was " + this.driver.getTitle() + " (" + this.driver.getCurrentUrl() + ")"), (boolean)this.isDeniedPage());
    }

    public void assertInvalidUserCodePage() {
        Assert.assertTrue((String)("Expected invalid user code page but was " + this.driver.getTitle() + " (" + this.driver.getCurrentUrl() + ")"), (boolean)this.isInvalidUserCodePage());
    }

    public void assertExpiredUserCodePage() {
        Assert.assertTrue((String)("Expected expired user code page but was " + this.driver.getTitle() + " (" + this.driver.getCurrentUrl() + ")"), (boolean)this.isExpiredUserCodePage());
    }

    private boolean isApprovedPage() {
        if (this.driver.getTitle().startsWith("Sign in to ")) {
            try {
                this.driver.findElement(By.id((String)"kc-page-title")).getText().equals("Device Login Successful");
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isDeniedPage() {
        if (this.driver.getTitle().startsWith("Sign in to ")) {
            try {
                return this.driver.findElement(By.id((String)"kc-page-title")).getText().equals("Device Login Failed") && this.driver.findElement(By.className((String)"instruction")).getText().equals(CONSENT_DENIED_MESSAGE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isInvalidUserCodePage() {
        if (this.driver.getTitle().startsWith("Sign in to ")) {
            try {
                this.driver.findElement(By.id((String)"device-user-code"));
                return this.driver.findElement(By.id((String)"kc-page-title")).getText().equals("Device Login") && this.driver.findElement(By.className((String)"kc-feedback-text")).getText().equals("Invalid code, please try again.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isExpiredUserCodePage() {
        if (this.driver.getTitle().startsWith("Sign in to ")) {
            try {
                this.driver.findElement(By.id((String)"device-user-code"));
                return this.driver.findElement(By.id((String)"kc-page-title")).getText().equals("Device Login") && this.driver.findElement(By.className((String)"kc-feedback-text")).getText().equals("The code has expired. Please go back to your device and try connecting again.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void open() {
    }
}

