/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginUsernameOnlyPage
extends LoginPage {
    @FindBy(id="input-error-username")
    private WebElement usernameError;

    @Override
    public void login(String username) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.submitButton.click();
    }

    public String getUsernameError() {
        try {
            return UIUtils.getTextFromElement(this.usernameError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    @Deprecated
    public void login(String username, String password) {
        throw new UnsupportedOperationException("Not supported - password field not available");
    }

    @Override
    @Deprecated
    public String getPassword() {
        throw new UnsupportedOperationException("Not supported - password field not available");
    }

    @Override
    @Deprecated
    public void missingPassword(String username) {
        throw new UnsupportedOperationException("Not supported - password field not available");
    }

    @Override
    public boolean isCurrent(String realm) {
        if (!super.isCurrent(realm)) {
            return false;
        }
        try {
            this.driver.findElement(By.id((String)"username"));
        }
        catch (NoSuchElementException nfe) {
            return false;
        }
        try {
            this.driver.findElement(By.id((String)"password"));
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }
}

