/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginUpdateProfilePage
extends AbstractPage {
    @Page
    private UpdateProfileErrors errorsPage;
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(id="department")
    private WebElement departmentInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(name="cancel-aia")
    private WebElement cancelAIAButton;
    @FindBy(className="alert-error")
    private WebElement loginAlertErrorMessage;

    public void update(String firstName, String lastName, String email) {
        this.updateWithDepartment(firstName, lastName, null, email);
    }

    public void updateWithDepartment(String firstName, String lastName, String department, String email) {
        if (firstName != null) {
            this.firstNameInput.clear();
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        if (lastName != null) {
            this.lastNameInput.clear();
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        if (email != null) {
            this.emailInput.clear();
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        if (department != null) {
            this.departmentInput.clear();
            this.departmentInput.sendKeys(new CharSequence[]{department});
        }
        UIUtils.clickLink(this.submitButton);
    }

    public void cancel() {
        this.cancelAIAButton.click();
    }

    public String getAlertError() {
        try {
            return UIUtils.getTextFromElement(this.loginAlertErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    public String getDepartment() {
        return this.departmentInput.getAttribute("value");
    }

    public boolean isDepartmentEnabled() {
        return this.departmentInput.isEnabled();
    }

    @Override
    public boolean isCurrent() {
        return PageUtils.getPageTitle(this.driver).equals("Update Account Information");
    }

    public UpdateProfileErrors getInputErrors() {
        return this.errorsPage;
    }

    public String getLabelForField(String fieldId) {
        return this.driver.findElement(By.cssSelector((String)("label[for=" + fieldId + "]"))).getText();
    }

    public boolean isDepartmentPresent() {
        try {
            this.isDepartmentEnabled();
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }

    public boolean isCancelDisplayed() {
        try {
            return this.cancelAIAButton.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static class UpdateProfileErrors {
        @FindBy(id="input-error-firstname")
        private WebElement inputErrorFirstName;
        @FindBy(id="input-error-firstName")
        private WebElement inputErrorFirstNameDynamic;
        @FindBy(id="input-error-lastname")
        private WebElement inputErrorLastName;
        @FindBy(id="input-error-lastName")
        private WebElement inputErrorLastNameDynamic;
        @FindBy(id="input-error-email")
        private WebElement inputErrorEmail;
        @FindBy(id="input-error-username")
        private WebElement inputErrorUsername;

        public String getFirstNameError() {
            try {
                return UIUtils.getTextFromElement(this.inputErrorFirstName);
            }
            catch (NoSuchElementException e) {
                try {
                    return UIUtils.getTextFromElement(this.inputErrorFirstNameDynamic);
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
        }

        public String getLastNameError() {
            try {
                return UIUtils.getTextFromElement(this.inputErrorLastName);
            }
            catch (NoSuchElementException e) {
                try {
                    return UIUtils.getTextFromElement(this.inputErrorLastNameDynamic);
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
        }

        public String getEmailError() {
            try {
                return UIUtils.getTextFromElement(this.inputErrorEmail);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        public String getUsernameError() {
            try {
                return UIUtils.getTextFromElement(this.inputErrorUsername);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

