/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.keycloak.testsuite.adapter.page.AppServerContextRoot;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AppServerWelcomePage
extends AppServerContextRoot {
    @Page
    @JavascriptBrowser
    protected OIDCLogin loginPage;
    @FindBy(xpath="//span[text() = 'Access Control']")
    private WebElement accessControlLink;
    @FindBy(xpath="//a[text() = 'Manage user profile']")
    private WebElement manageProfileLink;
    @FindBy(xpath="//div[text() = 'Logout']")
    private WebElement logoutLink;

    @Override
    public boolean isCurrent() {
        return DroneUtils.getCurrentDriver().getPageSource().contains("Access Control");
    }

    public void navigateToConsole() {
        URLUtils.navigateToUri(this.getInjectedUrl().toString() + "/console");
    }

    public void login(String username, String password) {
        Assert.assertTrue((boolean)this.loginPage.form().isLoginButtonPresent());
        this.loginPage.form().login(username, password);
        WaitUtils.waitForPageToLoad();
    }

    public void navigateToAccessControl() {
        this.accessControlLink.click();
        WaitUtils.waitForPageToLoad();
    }

    public void navigateManageProfile() {
        this.manageProfileLink.click();
        WaitUtils.waitForPageToLoad();
    }

    public void logout() {
        this.logoutLink.click();
        WaitUtils.waitForPageToLoad();
    }

    public boolean isLoginPage() {
        return this.loginPage.isCurrent();
    }
}

