/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import javax.ws.rs.core.UriBuilder;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AppPage
extends AbstractPage {
    @FindBy(id="account")
    private WebElement accountLink;

    @Override
    public void open() {
        this.driver.navigate().to(OAuthClient.APP_AUTH_ROOT);
    }

    @Override
    public boolean isCurrent() {
        return ServerURLs.removeDefaultPorts((String)this.driver.getCurrentUrl()).startsWith(OAuthClient.APP_AUTH_ROOT);
    }

    public RequestType getRequestType() {
        return RequestType.valueOf(this.driver.getTitle());
    }

    public void openAccount() {
        UIUtils.clickLink(this.accountLink);
    }

    public void logout() {
        Object[] objectArray = new Object[1];
        objectArray[0] = OAuthClient.APP_AUTH_ROOT;
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).queryParam("redirect_uri", objectArray).build(new Object[]{"test"}).toString();
        this.driver.navigate().to(logoutUri);
    }

    public static enum RequestType {
        AUTH_RESPONSE,
        LOGOUT_REQUEST,
        APP_REQUEST;

    }
}

