/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.services.Urls;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountFederatedIdentityPage
extends AbstractAccountPage {
    @FindBy(className="alert-error")
    private WebElement errorMessage;
    private String realmName = "test";

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void realm(String realmName) {
        this.realmName = realmName;
    }

    public String getPath() {
        return Urls.accountFederatedIdentityPage((URI)this.getAuthServerRoot(), (String)this.realmName).toString();
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getPageSource().contains("Federated Identities");
    }

    public List<FederatedIdentity> getIdentities() {
        LinkedList<FederatedIdentity> identities = new LinkedList<FederatedIdentity>();
        WebElement identitiesElement = this.driver.findElement(By.id((String)"federated-identities"));
        for (WebElement i : identitiesElement.findElements(By.className((String)"row"))) {
            String providerId = i.findElement(By.tagName((String)"label")).getText();
            String subject = i.findElement(By.tagName((String)"input")).getAttribute("value");
            WebElement button = i.findElement(By.tagName((String)"button"));
            identities.add(new FederatedIdentity(providerId, subject, button));
        }
        return identities;
    }

    public WebElement findAddProvider(String providerId) {
        return this.driver.findElement(By.id((String)("add-link-" + providerId)));
    }

    public void clickAddProvider(String providerId) {
        this.findAddProvider(providerId).click();
    }

    public void clickRemoveProvider(String providerId) {
        this.driver.findElement(By.id((String)("remove-link-" + providerId))).click();
    }

    public String getError() {
        return this.errorMessage.getText();
    }

    public boolean isLinked(String idpAlias) {
        return this.driver.getPageSource().contains("id=\"remove-link-" + idpAlias + "\"");
    }

    public static class FederatedIdentity {
        private String providerId;
        private String subject;
        private WebElement action;

        public FederatedIdentity(String providerId, String subject, WebElement action) {
            this.providerId = providerId;
            this.subject = subject;
            this.action = action;
        }

        public String getProvider() {
            return this.providerId;
        }

        public void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public WebElement getAction() {
            return this.action;
        }

        public void setAction(WebElement action) {
            this.action = action;
        }
    }
}

