/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.page;

import org.junit.Assert;
import org.keycloak.testsuite.page.AbstractPatternFlyAlert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.FindBy;

public class PatternFlyClosableAlert
extends AbstractPatternFlyAlert {
    @FindBy(xpath=".//button[@class='close']")
    protected WebElement closeButton;

    public boolean isInfo() {
        return this.checkAlertType("info");
    }

    public boolean isWarning() {
        return this.checkAlertType("warning");
    }

    public boolean isDanger() {
        return this.checkAlertType("danger");
    }

    @Override
    public void assertSuccess(String expectedText) {
        super.assertSuccess(expectedText);
        this.close();
    }

    public void assertInfo() {
        this.assertInfo(null);
    }

    public void assertInfo(String expectedText) {
        this.assertDisplayed();
        Assert.assertTrue((String)"Alert type should be info", (boolean)this.isInfo());
        if (expectedText != null) {
            Assert.assertEquals((Object)expectedText, (Object)this.getText());
        }
        this.close();
    }

    public void assertWarning() {
        this.assertWarning(null);
    }

    public void assertWarning(String expectedText) {
        this.assertDisplayed();
        Assert.assertTrue((String)"Alert type should be warning", (boolean)this.isWarning());
        if (expectedText != null) {
            Assert.assertEquals((Object)expectedText, (Object)this.getText());
        }
        this.close();
    }

    public void assertDanger() {
        this.assertDanger(null);
    }

    public void assertDanger(String expectedText) {
        this.assertDisplayed();
        Assert.assertTrue((String)"Alert type should be danger", (boolean)this.isDanger());
        if (expectedText != null) {
            Assert.assertEquals((Object)expectedText, (Object)this.getText());
        }
        this.close();
    }

    public void close() {
        try {
            this.closeButton.click();
            WaitUtils.pause(500L);
        }
        catch (WebDriverException e) {
            if (this.driver instanceof InternetExplorerDriver) {
                this.log.warn((Object)"Failed to close the alert; test is probably too slow and alert has already closed itself");
            }
            throw e;
        }
    }
}

