/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.drone;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilitiesRegistry;
import org.jboss.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class KeycloakWebDriverConfigurator {
    protected final Logger log = Logger.getLogger(KeycloakWebDriverConfigurator.class);
    @Inject
    private Instance<BrowserCapabilitiesRegistry> registryInstance;

    public void createConfiguration(@Observes BeforeDroneInstantiated event, DroneContext droneContext) {
        WebDriverConfiguration webDriverCfg = (WebDriverConfiguration)droneContext.get(event.getDronePoint()).getConfigurationAs(WebDriverConfiguration.class);
        DesiredCapabilities capabilitiesToAdd = new DesiredCapabilities();
        this.updateCapabilityKeys("htmlUnit", webDriverCfg, capabilitiesToAdd, new String[0]);
        this.updateCapabilityKeys("appium", webDriverCfg, capabilitiesToAdd, new String[0]);
        this.configurePhantomJSDriver(webDriverCfg, capabilitiesToAdd);
        this.acceptAllSSLCerts(webDriverCfg, capabilitiesToAdd);
        BrowserCapabilities browserCap = ((BrowserCapabilitiesRegistry)this.registryInstance.get()).getEntryFor(webDriverCfg.getBrowser());
        webDriverCfg.setBrowserInternal((BrowserCapabilities)new KcBrowserCapabilities((Capabilities)capabilitiesToAdd, browserCap));
    }

    private void acceptAllSSLCerts(WebDriverConfiguration webDriverCfg, DesiredCapabilities capabilitiesToAdd) {
        if (webDriverCfg.getBrowser().equals("internetexplorer")) {
            return;
        }
        capabilitiesToAdd.setCapability("acceptSslCerts", true);
        capabilitiesToAdd.setCapability("acceptInsecureCerts", true);
    }

    private void configurePhantomJSDriver(WebDriverConfiguration webDriverCfg, DesiredCapabilities capabilitiesToAdd) {
        if (!webDriverCfg.getBrowser().equals("phantomjs")) {
            return;
        }
        String cliArgs = System.getProperty("keycloak.phantomjs.cli.args");
        if (cliArgs == null) {
            cliArgs = "--ignore-ssl-errors=true --web-security=false";
        }
        capabilitiesToAdd.setCapability("phantomjs.cli.args", cliArgs);
    }

    private void updateCapabilityKeys(String browser, WebDriverConfiguration webDriverCfg, DesiredCapabilities capabilitiesToAdd, String ... exclude) {
        if (!webDriverCfg.getBrowser().toLowerCase().equals(browser.toLowerCase())) {
            return;
        }
        List<String> excludeList = Arrays.asList(exclude);
        String key = browser + ".";
        int keyLength = key.length();
        for (Map.Entry capability : webDriverCfg.getCapabilities().asMap().entrySet()) {
            if (excludeList.contains(capability.getKey()) || !((String)capability.getKey()).startsWith(key)) continue;
            capabilitiesToAdd.setCapability(((String)capability.getKey()).substring(keyLength), capability.getValue());
        }
    }

    public static class KcBrowserCapabilities
    implements BrowserCapabilities {
        private Capabilities capabilitiesToAdd;
        private BrowserCapabilities origBrowserCapabilities;

        public KcBrowserCapabilities(Capabilities capabilitiesToAdd, BrowserCapabilities origBrowserCapabilities) {
            this.capabilitiesToAdd = capabilitiesToAdd;
            this.origBrowserCapabilities = origBrowserCapabilities;
        }

        public String getImplementationClassName() {
            return this.origBrowserCapabilities.getImplementationClassName();
        }

        public Map<String, ?> getRawCapabilities() {
            HashMap ret = new HashMap(this.origBrowserCapabilities.getRawCapabilities());
            ret.putAll(this.capabilitiesToAdd.asMap());
            return ret;
        }

        public String getReadableName() {
            return this.origBrowserCapabilities.getReadableName();
        }

        public int getPrecedence() {
            return this.origBrowserCapabilities.getPrecedence();
        }
    }
}

