/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.drone;

import io.appium.java_client.AppiumDriver;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class KeycloakDronePostSetup {
    protected static final Logger log = Logger.getLogger(KeycloakDronePostSetup.class);

    public void configureWebDriver(@Observes AfterDroneEnhanced event, DroneContext droneContext) {
        DronePoint dronePoint = event.getDronePoint();
        Object drone = droneContext.get(dronePoint).getInstance();
        if (drone instanceof RemoteWebDriver) {
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)drone;
            log.infof("Detected browser: %s %s", (Object)remoteWebDriver.getCapabilities().getBrowserName(), (Object)remoteWebDriver.getCapabilities().getVersion());
        }
        if (drone instanceof WebDriver && !(drone instanceof AppiumDriver)) {
            WebDriver webDriver = (WebDriver)drone;
            this.configureDriverSettings(webDriver);
        } else {
            log.warn((Object)("Drone is not instanceof WebDriver for a desktop browser! Drone is " + drone));
        }
        if (drone instanceof GrapheneProxyInstance) {
            GrapheneProxyInstance droneProxy = (GrapheneProxyInstance)drone;
            if (drone instanceof HtmlUnitDriver) {
                droneProxy.registerInterceptor((Interceptor)new HtmlUnitInterceptor());
            }
        } else {
            log.warn((Object)("Drone is not instanceof GrapheneProxyInstance! Drone is " + drone));
        }
    }

    private void configureDriverSettings(WebDriver driver) {
        long implicitWaitMillis = 1500L;
        long pageLoadTimeoutMillis = WaitUtils.PAGELOAD_TIMEOUT_MILLIS.intValue();
        log.infof("Configuring driver settings. implicitWait=%d, pageLoadTimeout=%d", (Object)implicitWaitMillis, (Object)pageLoadTimeoutMillis);
        driver.manage().timeouts().implicitlyWait(implicitWaitMillis, TimeUnit.MILLISECONDS);
        driver.manage().timeouts().pageLoadTimeout(pageLoadTimeoutMillis, TimeUnit.MILLISECONDS);
        driver.manage().window().maximize();
    }

    public static class HtmlUnitInterceptor
    implements Interceptor {
        public Object intercept(InvocationContext context) throws Throwable {
            if (context.getMethod().getName().equals("executeScript")) {
                String currentUrl = ((WebDriver)context.getTarget()).getCurrentUrl();
                int refreshCount = 0;
                while (true) {
                    try {
                        if ("about:blank".equals(currentUrl)) {
                            log.debug((Object)"Ignored JS as we are on about:blank page now");
                            return null;
                        }
                        return context.invoke();
                    }
                    catch (UnsupportedOperationException e) {
                        if ("Cannot execute JS against a plain text page".equals(e.getMessage())) {
                            if (++refreshCount < 2) {
                                log.debugf("Will try to refresh current page: %s", (Object)currentUrl);
                                ((WebDriver)context.getProxy()).navigate().to(currentUrl);
                                continue;
                            }
                            log.debugf("Current page doesn't seem to support javascript. Current url: %s", (Object)currentUrl);
                            return null;
                        }
                        throw e;
                    }
                    break;
                }
            }
            return context.invoke();
        }

        public int getPrecedence() {
            return -1;
        }
    }
}

