/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import org.jboss.arquillian.graphene.fragment.Root;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class KcPassword {
    @Root
    private WebElement inputField;
    @FindBy(xpath="../span[contains(@class,'input-group-addon') and ./span[contains(@class,'fa-eye')]]")
    private WebElement eyeButton;

    public void setValue(String value) {
        UIUtils.setTextInputValue(this.inputField, value);
    }

    public boolean isMasked() {
        return this.inputField.getAttribute("class").contains("password-conceal");
    }

    public boolean isEyeButtonDisabled() {
        return this.eyeButton.getAttribute("class").contains("disabled");
    }

    public void clickEyeButton() {
        if (this.isEyeButtonDisabled()) {
            throw new ElementNotInteractableException("The eye button is disabled and cannot be clicked");
        }
        this.eyeButton.click();
    }

    public WebElement getElement() {
        return this.inputField;
    }
}

