/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.events;

import org.keycloak.testsuite.console.page.events.Events;
import org.keycloak.testsuite.console.page.fragment.DataTable;
import org.keycloak.testsuite.page.Form;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginEvents
extends Events {
    @FindBy(tagName="table")
    private LoginEventsTable table;

    @Override
    public String getUriFragment() {
        return super.getUriFragment() + "/events";
    }

    public LoginEventsTable table() {
        return this.table;
    }

    public static class LoginEventsTable
    extends DataTable {
        @FindBy(xpath="//button[text()[contains(.,'Filter')]]")
        private WebElement filterButton;
        @FindBy(tagName="form")
        private LoginEventsTableFilterForm filterForm;

        public void update() {
            this.clickHeaderButton("Update");
        }

        public void reset() {
            this.clickHeaderButton("Reset");
        }

        public void filter() {
            this.filterButton.click();
        }

        public LoginEventsTableFilterForm filterForm() {
            return this.filterForm;
        }

        public class LoginEventsTableFilterForm
        extends Form {
            @FindBy(id="client")
            private WebElement clientInput;
            @FindBy(id="user")
            private WebElement userInput;
            @FindBy(xpath="//div[@id='s2id_eventTypes']/ul")
            private WebElement eventTypeInput;
            @FindBy(xpath="//div[@id='select2-drop']")
            private WebElement eventTypeValues;

            public void addEventType(String type) {
                this.eventTypeInput.click();
                this.eventTypeValues.findElement(By.xpath((String)("//div[text()='" + type + "']"))).click();
            }

            public void removeOperationType(String type) {
                this.eventTypeInput.findElement(By.xpath((String)("//div[text()='" + type + "']/../a]"))).click();
            }

            public void setClientInput(String value) {
                UIUtils.setTextInputValue(this.clientInput, value);
            }

            public void setUserInput(String value) {
                UIUtils.setTextInputValue(this.userInput, value);
            }
        }
    }
}

