/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client.resources;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.client.resources.TestingCacheResource;
import org.keycloak.testsuite.client.resources.TestingExportImportResource;
import org.keycloak.testsuite.client.resources.TestingLDAPResource;
import org.keycloak.testsuite.components.TestProvider;
import org.keycloak.testsuite.rest.representation.AuthenticatorState;

@Path(value="/testing")
@Consumes(value={"application/json"})
public interface TestingResource {
    @GET
    @Path(value="/time-offset")
    @Produces(value={"application/json"})
    public Map<String, String> getTimeOffset();

    @PUT
    @Path(value="/time-offset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> setTimeOffset(Map<String, String> var1);

    @POST
    @Path(value="/poll-event-queue")
    @Produces(value={"application/json"})
    public EventRepresentation pollEvent();

    @POST
    @Path(value="/poll-admin-event-queue")
    @Produces(value={"application/json"})
    public AdminEventRepresentation pollAdminEvent();

    @POST
    @Path(value="/clear-event-queue")
    @Produces(value={"application/json"})
    public void clearEventQueue();

    @POST
    @Path(value="/clear-admin-event-queue")
    @Produces(value={"application/json"})
    public void clearAdminEventQueue();

    @GET
    @Path(value="/clear-event-store")
    @Produces(value={"application/json"})
    public void clearEventStore();

    @GET
    @Path(value="/clear-event-store-for-realm")
    @Produces(value={"application/json"})
    public void clearEventStore(@QueryParam(value="realmId") String var1);

    @GET
    @Path(value="/clear-expired-events")
    @Produces(value={"application/json"})
    public void clearExpiredEvents();

    @Path(value="query-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<EventRepresentation> queryEvents(@QueryParam(value="realmId") String var1, @QueryParam(value="type") List<String> var2, @QueryParam(value="client") String var3, @QueryParam(value="user") String var4, @QueryParam(value="dateFrom") String var5, @QueryParam(value="dateTo") String var6, @QueryParam(value="ipAddress") String var7, @QueryParam(value="first") Integer var8, @QueryParam(value="max") Integer var9);

    @PUT
    @Path(value="/on-event")
    @Consumes(value={"application/json"})
    public void onEvent(EventRepresentation var1);

    @GET
    @Path(value="/clear-admin-event-store")
    @Produces(value={"application/json"})
    public void clearAdminEventStore();

    @GET
    @Path(value="/clear-admin-event-store-for-realm")
    @Produces(value={"application/json"})
    public void clearAdminEventStore(@QueryParam(value="realmId") String var1);

    @GET
    @Path(value="/clear-admin-event-store-older-than")
    @Produces(value={"application/json"})
    public void clearAdminEventStore(@QueryParam(value="realmId") String var1, @QueryParam(value="olderThan") long var2);

    @Path(value="query-admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<AdminEventRepresentation> getAdminEvents(@QueryParam(value="realmId") String var1, @QueryParam(value="operationTypes") List<String> var2, @QueryParam(value="authRealm") String var3, @QueryParam(value="authClient") String var4, @QueryParam(value="authUser") String var5, @QueryParam(value="authIpAddress") String var6, @QueryParam(value="resourcePath") String var7, @QueryParam(value="dateFrom") String var8, @QueryParam(value="dateTo") String var9, @QueryParam(value="first") Integer var10, @QueryParam(value="max") Integer var11);

    @POST
    @Path(value="/on-admin-event")
    @Consumes(value={"application/json"})
    public void onAdminEvent(AdminEventRepresentation var1, @QueryParam(value="includeRepresentation") boolean var2);

    @GET
    @Path(value="/get-sso-cookie")
    @Produces(value={"application/json"})
    public String getSSOCookieValue();

    @POST
    @Path(value="/remove-user-session")
    @Produces(value={"application/json"})
    public void removeUserSession(@QueryParam(value="realm") String var1, @QueryParam(value="session") String var2);

    @POST
    @Path(value="/remove-user-sessions")
    @Produces(value={"application/json"})
    public void removeUserSessions(@QueryParam(value="realm") String var1);

    @GET
    @Path(value="/get-last-session-refresh")
    @Produces(value={"application/json"})
    public Integer getLastSessionRefresh(@QueryParam(value="realm") String var1, @QueryParam(value="session") String var2, @QueryParam(value="offline") boolean var3);

    @POST
    @Path(value="/remove-expired")
    @Produces(value={"application/json"})
    public void removeExpired(@QueryParam(value="realm") String var1);

    @POST
    @Path(value="/set-testing-infinispan-time-service")
    @Produces(value={"application/json"})
    public void setTestingInfinispanTimeService();

    @POST
    @Path(value="/revert-testing-infinispan-time-service")
    @Produces(value={"application/json"})
    public void revertTestingInfinispanTimeService();

    @GET
    @Path(value="/get-client-sessions-count")
    @Produces(value={"application/json"})
    public Integer getClientSessionsCountInUserSession(@QueryParam(value="realm") String var1, @QueryParam(value="session") String var2);

    @Path(value="/cache/{cache}")
    public TestingCacheResource cache(@PathParam(value="cache") String var1);

    @Path(value="/ldap/{realm}")
    public TestingLDAPResource ldap(@PathParam(value="realm") String var1);

    @POST
    @Path(value="/update-pass-through-auth-state")
    @Produces(value={"application/json"})
    public AuthenticatorState updateAuthenticator(AuthenticatorState var1);

    @GET
    @Path(value="/valid-credentials")
    @Produces(value={"application/json"})
    public boolean validCredentials(@QueryParam(value="realmName") String var1, @QueryParam(value="userName") String var2, @QueryParam(value="password") String var3);

    @GET
    @Path(value="/user-by-federated-identity")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByFederatedIdentity(@QueryParam(value="realmName") String var1, @QueryParam(value="identityProvider") String var2, @QueryParam(value="userId") String var3, @QueryParam(value="userName") String var4);

    @GET
    @Path(value="/user-by-username-from-fed-factory")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByUsernameFromFedProviderFactory(@QueryParam(value="realmName") String var1, @QueryParam(value="userName") String var2);

    @GET
    @Path(value="/get-client-auth-flow")
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getClientAuthFlow(@QueryParam(value="realmName") String var1);

    @GET
    @Path(value="/get-reset-cred-flow")
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getResetCredFlow(@QueryParam(value="realmName") String var1);

    @GET
    @Path(value="/get-user-by-service-account-client")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByServiceAccountClient(@QueryParam(value="realmName") String var1, @QueryParam(value="clientId") String var2);

    @Path(value="export-import")
    public TestingExportImportResource exportImport();

    @GET
    @Path(value="/test-component")
    @Produces(value={"application/json"})
    public Map<String, TestProvider.DetailsRepresentation> getTestComponentDetails();

    @GET
    @Path(value="/test-amphibian-component")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Object>> getTestAmphibianComponentDetails();

    @GET
    @Path(value="/identity-config")
    @Produces(value={"application/json"})
    public Map<String, String> getIdentityProviderConfig(@QueryParam(value="alias") String var1);

    @PUT
    @Path(value="/set-krb5-conf-file")
    @Consumes(value={"application/json"})
    public void setKrb5ConfFile(@QueryParam(value="krb5-conf-file") String var1);

    @POST
    @Path(value="/suspend-periodic-tasks")
    @Produces(value={"application/json"})
    public Response suspendPeriodicTasks();

    @POST
    @Path(value="/restore-periodic-tasks")
    @Produces(value={"application/json"})
    public Response restorePeriodicTasks();

    @Path(value="generate-audience-client-scope")
    @POST
    @NoCache
    public String generateAudienceClientScope(@QueryParam(value="realm") String var1, @QueryParam(value="clientId") String var2);

    @GET
    @Path(value="/uncaught-error")
    @Produces(value={"text/html; charset=utf-8"})
    public Response uncaughtError();

    @GET
    @Path(value="/uncaught-error")
    public Response uncaughtErrorJson();

    @POST
    @Path(value="/run-on-server")
    @Consumes(value={"text/plain; charset=utf-8"})
    @Produces(value={"text/plain; charset=utf-8"})
    public String runOnServer(String var1);

    @POST
    @Path(value="/run-model-test-on-server")
    @Consumes(value={"text/plain; charset=utf-8"})
    @Produces(value={"text/plain; charset=utf-8"})
    public String runModelTestOnServer(@QueryParam(value="testClassName") String var1, @QueryParam(value="testMethodName") String var2);

    @GET
    @Path(value="js/keycloak.js")
    @Produces(value={"text/html; charset=utf-8"})
    public String getJavascriptAdapter();

    @GET
    @Path(value="/get-javascript-testing-environment")
    @Produces(value={"text/html; charset=utf-8"})
    public String getJavascriptTestingEnvironment();

    @POST
    @Path(value="/enable-feature/{feature}")
    @Consumes(value={"application/json"})
    public Response enableFeature(@PathParam(value="feature") String var1);

    @POST
    @Path(value="/disable-feature/{feature}")
    @Consumes(value={"application/json"})
    public Response disableFeature(@PathParam(value="feature") String var1);

    @GET
    @Path(value="/set-system-property")
    @Consumes(value={"text/html; charset=utf-8"})
    public void setSystemPropertyOnServer(@QueryParam(value="property-name") String var1, @QueryParam(value="property-value") String var2);

    @GET
    @Path(value="/simulate-post-request")
    @Produces(value={"text/html; charset=utf-8"})
    public Response simulatePostRequest(@QueryParam(value="postRequestUrl") String var1, @QueryParam(value="encodedFormParameters") String var2);
}

