/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli;

import java.io.InputStream;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.exec.AbstractExecBuilder;

public class KcRegExec
extends AbstractExec {
    public static final String WORK_DIR = System.getProperty("user.dir") + "/target/containers/keycloak-client-tools";
    public static final String CMD = OS_ARCH.isWindows() ? "kcreg.bat" : "kcreg.sh";

    private KcRegExec(String workDir, String argsLine, InputStream stdin) {
        this(workDir, argsLine, null, stdin);
    }

    private KcRegExec(String workDir, String argsLine, String env, InputStream stdin) {
        super(workDir, argsLine, env, stdin);
    }

    @Override
    public String getCmd() {
        return "bin/" + CMD;
    }

    public static Builder newBuilder() {
        return (Builder)new Builder().workDir(WORK_DIR);
    }

    public static KcRegExec execute(String args) {
        return (KcRegExec)KcRegExec.newBuilder().argsLine(args).execute();
    }

    public static class Builder
    extends AbstractExecBuilder<KcRegExec> {
        @Override
        public KcRegExec execute() {
            KcRegExec exe = new KcRegExec(this.workDir, this.argsLine, this.env, this.stdin);
            exe.dumpStreams = this.dumpStreams;
            exe.execute();
            return exe;
        }

        @Override
        public KcRegExec executeAsync() {
            KcRegExec exe = new KcRegExec(this.workDir, this.argsLine, this.env, this.stdin);
            exe.dumpStreams = this.dumpStreams;
            exe.executeAsync();
            return exe;
        }
    }
}

