/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli;

import java.io.InputStream;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.exec.AbstractExecBuilder;

public class KcAdmExec
extends AbstractExec {
    public static final String WORK_DIR = System.getProperty("user.dir") + "/target/containers/keycloak-client-tools";
    public static final String CMD = OS_ARCH.isWindows() ? "kcadm.bat" : "kcadm.sh";

    private KcAdmExec(String workDir, String argsLine, InputStream stdin) {
        this(workDir, argsLine, null, stdin);
    }

    private KcAdmExec(String workDir, String argsLine, String env, InputStream stdin) {
        super(workDir, argsLine, env, stdin);
    }

    @Override
    public String getCmd() {
        return "bin/" + CMD;
    }

    public static Builder newBuilder() {
        return (Builder)new Builder().workDir(WORK_DIR);
    }

    public static KcAdmExec execute(String args) {
        return (KcAdmExec)KcAdmExec.newBuilder().argsLine(args).execute();
    }

    public static class Builder
    extends AbstractExecBuilder<KcAdmExec> {
        @Override
        public KcAdmExec execute() {
            KcAdmExec exe = new KcAdmExec(this.workDir, this.argsLine, this.env, this.stdin);
            exe.dumpStreams = this.dumpStreams;
            exe.execute();
            return exe;
        }

        @Override
        public KcAdmExec executeAsync() {
            KcAdmExec exe = new KcAdmExec(this.workDir, this.argsLine, this.env, this.stdin);
            exe.dumpStreams = this.dumpStreams;
            exe.executeAsync();
            return exe;
        }
    }
}

