/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import org.keycloak.testsuite.auth.page.login.Authenticate;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OneTimeCode
extends Authenticate {
    @FindBy(id="otp")
    private WebElement otpInputField;
    @FindBy(xpath=".//label[@for='otp']")
    private WebElement otpInputLabel;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(id="input-error-otp-code")
    private WebElement totpInputCodeError;

    public String getOtpLabel() {
        return UIUtils.getTextFromElement(this.otpInputLabel);
    }

    public boolean isOtpLabelPresent() {
        try {
            return this.otpInputLabel.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void sendCode(String code) {
        this.setOtp(code);
        this.submit();
    }

    public String getAlertError() {
        try {
            return UIUtils.getTextFromElement(this.loginErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getInputError() {
        try {
            return UIUtils.getTextFromElement(this.totpInputCodeError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean isCurrent() {
        return URLUtils.currentUrlStartsWith(this.toString() + "?") && this.isOtpLabelPresent();
    }

    public void setOtp(String value) {
        UIUtils.setTextInputValue(this.otpInputField, value);
    }
}

