/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.testsuite.auth.page.login.RequiredActions;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OAuthGrant
extends RequiredActions {
    @FindBy(css="input[name=\"accept\"]")
    private WebElement acceptButton;
    @FindBy(css="input[name=\"cancel\"]")
    private WebElement cancelButton;
    @FindBy(xpath="//div[@id='kc-oauth']/ul/li/span")
    private List<WebElement> scopesToApprove;

    @Override
    public String getActionId() {
        return CommonClientSessionModel.Action.OAUTH_GRANT.name();
    }

    public void accept() {
        UIUtils.clickLink(this.acceptButton);
    }

    @Override
    public void cancel() {
        UIUtils.clickLink(this.cancelButton);
    }

    public boolean isCurrent(WebDriver driver1) {
        DroneUtils.addWebDriver(driver1);
        boolean ret = super.isCurrent();
        DroneUtils.removeWebDriver();
        return ret;
    }

    public void assertClientScopes(List<String> expectedScopes) {
        List actualScopes = this.scopesToApprove.stream().map(WebElement::getText).collect(Collectors.toList());
        Assert.assertTrue((String)"Expected and actual Client Scopes to approve don't match", (boolean)CollectionUtil.collectionEquals(expectedScopes, actualScopes));
    }
}

