/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.AccountFields;
import org.keycloak.testsuite.auth.page.PasswordFields;
import org.keycloak.testsuite.page.Form;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginForm
extends Form {
    @Page
    private AccountFields accountFields;
    @Page
    private PasswordFields passwordFields;
    @Page
    private TotpSetupForm totpForm;
    @FindBy(name="login")
    private WebElement loginButton;
    @FindBy(xpath="//div[@id='kc-registration']/span/a")
    private WebElement registerLink;
    @FindBy(linkText="Forgot Password?")
    private WebElement forgottenPassword;
    @FindBy(id="rememberMe")
    private WebElement rememberMe;
    @FindBy(xpath="//input[@id='rememberMe']/parent::label")
    private WebElement rememberMeLabel;

    public void setUsername(String username) {
        this.accountFields.setUsername(username);
    }

    public void setPassword(String password) {
        this.passwordFields.setPassword(password);
    }

    public void login(UserRepresentation user) {
        this.login(user.getUsername(), Users.getPasswordOf(user));
    }

    public void login(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
        this.login();
    }

    public void register() {
        UIUtils.clickLink(this.registerLink);
    }

    public void login() {
        UIUtils.clickLink(this.loginButton);
    }

    public void forgotPassword() {
        UIUtils.clickLink(this.forgottenPassword);
    }

    public void rememberMe(boolean value) {
        boolean selected = this.rememberMe.isSelected();
        if (value && !selected || !value && selected) {
            this.rememberMe.click();
        }
    }

    public boolean isRememberMe() {
        return this.rememberMe.isSelected();
    }

    public boolean isUsernamePresent() {
        return this.accountFields.isUsernamePresent();
    }

    public boolean isRegisterLinkPresent() {
        try {
            return this.registerLink.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isForgotPasswordLinkPresent() {
        try {
            return this.forgottenPassword.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isRememberMePresent() {
        try {
            return this.rememberMe.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isLoginButtonPresent() {
        try {
            return this.loginButton.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public TotpSetupForm totpForm() {
        return this.totpForm;
    }

    public String getUsernameLabel() {
        return this.accountFields.getUsernameLabel();
    }

    public String getUsername() {
        return this.accountFields.getUsername();
    }

    public String getPasswordLabel() {
        return this.passwordFields.getPasswordLabel();
    }

    public String getRememberMeLabel() {
        return UIUtils.getTextFromElement(this.rememberMeLabel);
    }

    public static class TotpSetupForm
    extends Form {
        @FindBy(id="totp")
        private WebElement totpInputField;
        @FindBy(id="userLabel")
        private WebElement userLabelInputField;
        @FindBy(id="totpSecret")
        private WebElement totpSecret;
        @FindBy(xpath=".//input[@value='Submit']")
        private WebElement submit;

        public void setTotp(String value) {
            UIUtils.setTextInputValue(this.totpInputField, value);
        }

        public void setUserLabel(String value) {
            UIUtils.setTextInputValue(this.userLabelInputField, value);
        }

        public String getTotpSecret() {
            return this.totpSecret.getAttribute("value");
        }

        public void submit() {
            UIUtils.clickLink(this.submit);
        }
    }
}

