/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.login.FeedbackMessage;
import org.keycloak.testsuite.console.page.fragment.LocaleDropdown;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class LoginBase
extends AuthRealm {
    @Page
    protected FeedbackMessage feedbackMessage;
    @FindBy(id="kc-page-title")
    protected WebElement title;
    @FindBy(id="kc-header-wrapper")
    protected WebElement header;
    @FindBy(id="kc-locale")
    private LocaleDropdown localeDropdown;
    protected String keycloakThemeCssName;

    public FeedbackMessage feedbackMessage() {
        return this.feedbackMessage;
    }

    public String getTitleText() {
        return UIUtils.getTextFromElement(this.title);
    }

    public String getHeaderText() {
        return UIUtils.getTextFromElement(this.header);
    }

    protected By getKeycloakThemeLocator() {
        if (this.keycloakThemeCssName == null) {
            throw new IllegalStateException("keycloakThemeCssName property must be set");
        }
        return By.cssSelector((String)("link[href*='login/" + this.keycloakThemeCssName + "/css/login.css']"));
    }

    public void waitForKeycloakThemeNotPresent() {
        ((IsElementBuilder)WaitUtils.waitUntilElement(this.getKeycloakThemeLocator()).is().not()).present();
    }

    public void waitForKeycloakThemePresent() {
        WaitUtils.waitUntilElement(this.getKeycloakThemeLocator()).is().present();
    }

    public void setKeycloakThemeCssName(String name) {
        this.keycloakThemeCssName = name;
    }

    public LocaleDropdown localeDropdown() {
        return this.localeDropdown;
    }
}

