/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page;

import org.keycloak.testsuite.auth.page.AuthServer;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WelcomePage
extends AuthServer {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="passwordConfirmation")
    private WebElement passwordConfirmationInput;
    @FindBy(id="create-button")
    private WebElement createButton;
    @FindBy(css=".welcome-header h1")
    private WebElement welcomeMessage;

    public boolean isPasswordSet() {
        return !this.driver.getPageSource().contains("Please create an initial admin user to get started.") && !this.driver.getPageSource().contains("You need local access to create the initial admin user.");
    }

    public void setPassword(String username, String password) {
        UIUtils.setTextInputValue(this.usernameInput, username);
        UIUtils.setTextInputValue(this.passwordInput, password);
        UIUtils.setTextInputValue(this.passwordConfirmationInput, password);
        UIUtils.clickLink(this.createButton);
        if (!this.driver.getPageSource().contains("User created")) {
            throw new RuntimeException("Failed to updated password");
        }
    }

    public void navigateToAdminConsole() {
        UIUtils.clickLink(this.driver.findElement(By.linkText((String)"Administration Console")));
    }

    public String getWelcomeMessage() {
        return UIUtils.getTextFromElement(this.welcomeMessage);
    }
}

