/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page;

import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.auth.page.FieldsBase;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountFields
extends FieldsBase {
    @Page
    private AccountErrors inputErrors;
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(xpath="//label[@for='username']")
    private WebElement usernameLabel;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(xpath="//label[@for='email']")
    private WebElement emailLabel;
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(xpath="//label[@for='firstName']")
    private WebElement firstNameLabel;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(xpath="//label[@for='lastName']")
    private WebElement lastNameLabel;

    public void setUsername(String username) {
        UIUtils.setTextInputValue(this.usernameInput, username);
    }

    public AccountFields setEmail(String email) {
        UIUtils.setTextInputValue(this.emailInput, email);
        return this;
    }

    public AccountFields setFirstName(String firstName) {
        UIUtils.setTextInputValue(this.firstNameInput, firstName);
        return this;
    }

    public AccountFields setLastName(String lastName) {
        UIUtils.setTextInputValue(this.lastNameInput, lastName);
        return this;
    }

    public String getUsername() {
        return UIUtils.getTextInputValue(this.usernameInput);
    }

    public String getEmail() {
        return UIUtils.getTextInputValue(this.emailInput);
    }

    public String getFirstName() {
        return UIUtils.getTextInputValue(this.firstNameInput);
    }

    public String getLastName() {
        return UIUtils.getTextInputValue(this.lastNameInput);
    }

    public void setValues(UserRepresentation user) {
        this.setUsername(user.getUsername());
        this.setEmail(user.getEmail());
        this.setFirstName(user.getFirstName());
        this.setLastName(user.getLastName());
    }

    public boolean isUsernamePresent() {
        try {
            return this.usernameInput.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getUsernameLabel() {
        return UIUtils.getTextFromElement(this.usernameLabel);
    }

    public String getEmailLabel() {
        return UIUtils.getTextFromElement(this.emailLabel);
    }

    public String getFirstNameLabel() {
        return UIUtils.getTextFromElement(this.firstNameLabel);
    }

    public String getLastNameLabel() {
        return UIUtils.getTextFromElement(this.lastNameLabel);
    }

    public boolean hasUsernameError() {
        return this.inputErrors.getUsernameError() != null;
    }

    public boolean hasEmailError() {
        return this.inputErrors.getEmailError() != null;
    }

    public boolean hasFirstNameError() {
        return this.inputErrors.getFirstNameError() != null;
    }

    public boolean hasLastNameError() {
        return this.inputErrors.getLastNameError() != null;
    }

    public AccountErrors getInputErrors() {
        return this.inputErrors;
    }

    public static class AccountErrors {
        @FindBy(id="input-error-firstname")
        private WebElement firstNameError;
        @FindBy(id="input-error-firstName")
        private WebElement firstNameDynamicError;
        @FindBy(id="input-error-lastname")
        private WebElement lastNameError;
        @FindBy(id="input-error-lastName")
        private WebElement lastNameDynamicError;
        @FindBy(id="input-error-email")
        private WebElement emailError;
        @FindBy(id="input-error-username")
        private WebElement usernameError;

        public String getFirstNameError() {
            try {
                return UIUtils.getTextFromElement(this.firstNameError);
            }
            catch (NoSuchElementException e) {
                try {
                    return UIUtils.getTextFromElement(this.firstNameDynamicError);
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
        }

        public String getLastNameError() {
            try {
                return UIUtils.getTextFromElement(this.lastNameError);
            }
            catch (NoSuchElementException e) {
                try {
                    return UIUtils.getTextFromElement(this.lastNameDynamicError);
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
        }

        public String getEmailError() {
            try {
                return UIUtils.getTextFromElement(this.emailError);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        public String getUsernameError() {
            try {
                return UIUtils.getTextFromElement(this.usernameError);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

